import React, { useState, useEffect } from "react";
import HeaderNavbar from "../../Components/Navbar/Header/Header";
import Footerone from "../../Components/Footer/Footerone";
import ViewPropertyPage from "./ViewPropertyPage";
import { Favorite as HeartFilled } from "@mui/icons-material";

function ViewProperty() {
  const [user, setUser] = useState(null);
  // Fetch saved user from localStorage
  useEffect(() => {
    const storedUser = localStorage.getItem("user");
    if (storedUser) setUser(JSON.parse(storedUser));
  }, []);
  return (
    <>
      <HeaderNavbar user={user} setUser={setUser} />
      <ViewPropertyPage  />
      <Footerone />
    </>
  );
}

export default ViewProperty;