import React, { useState, useEffect } from 'react';
import {
    Box,
    Typography,
    TextField,
    Button,
    Checkbox,
    Autocomplete,
    FormControlLabel,
    FormControl,
    FormLabel,
    RadioGroup,
    Radio
} from '@mui/material';
import { Col, Row } from 'antd';
import { useLocation, useNavigate } from 'react-router-dom';
import axios from 'axios';



const UserEnquiry = () => {
    const location = useLocation();
    const navigate = useNavigate();
    const phone = location.state?.phone || '';

    const [name, setName] = useState('');
    const [email, setEmail] = useState('');
    const [mobileno, setMobileno] = useState(phone); // prefill from OTP
    const [isAgent, setIsAgent] = useState('no');
    const [isAgreed, setIsAgreed] = useState(false);
    const [selectedCity, setSelectedCity] = useState(null);
    const [whoYouAre, setWhoYouAre] = useState(null);
    const [cityData, setCityData] = useState([]);
    const [userType, setUserType] = useState([])
    useEffect(() => {
        async function fetchCity() {
            const response = await axios.get(`http://localhost:3001/city-masters`);
            console.log(response.data)
            setCityData(response.data)
        }

        async function fetchUsertype() {
            const response = await axios.get(`http://localhost:3001/usertypes`)
            console.log(response.data);
            setUserType(response.data)
        }
        fetchCity();
        fetchUsertype();
    }, [])
 const handleSubmit = async () => {
  if (!name || !email || !mobileno || !isAgreed) {
    alert('Please fill all required fields.');
    return;
  }

  const identity = whoYouAre?.userId;
  const cityId = selectedCity?.cityId;

  try {
    if (identity !== 1) {
      const sellerData = {
        fkuserId: identity,
        fkcityId: cityId,
        fkpackageId: 1,
        paymentFlag: 0,
        sellerName: name,
        sellerGmail: email,
        sellerMobile: Number(mobileno),
        lastChanged: new Date().toISOString()
      };

      // Call text-only API
      const res = await axios.post(
        'http://localhost:3001/seller-masters-text',
        sellerData
      );

      console.log("Seller created:", res.data);

      // Save sellerId for step 2 (image upload)
      localStorage.setItem("sellerId", res.data.sellerId);

      alert('✅ Seller text fields saved!');
    }
    navigate('/dashboard');
  } catch (error) {
    console.error(error);
    alert('Something went wrong during registration.');
  }
};

    return (
        <Box
            sx={{
                background: '#f5f5f5',
                minHeight: '100vh',
                padding: '30px',
                display: 'flex',
                justifyContent: 'center',
            }}
        >
            <Box
                sx={{
                    background: 'white',
                    padding: 4,
                    borderRadius: 3,
                    boxShadow: 3,
                    width: '100%',
                    maxWidth: '700px',
                }}
            >
                <Typography variant="h5" fontWeight="bold" color="#0d47a1" mb={3}>
                    Create Account
                </Typography>

                <Row gutter={[16, 16]}>
                    <Col span={12}>
                        <TextField
                            label="Full Name"
                            fullWidth
                            value={name}
                            onChange={(e) => setName(e.target.value)}
                        />
                    </Col>
                    <Col span={12}>
                        <TextField
                            label="Email"
                            fullWidth
                            type="email"
                            value={email}
                            onChange={(e) => setEmail(e.target.value)}
                        />
                    </Col>
                </Row>

                <Row gutter={[16, 16]} style={{ marginTop: '15px' }}>
                    <Col span={12}>
                        <TextField
                            label="Mobile No"
                            fullWidth
                            value={mobileno}
                            inputProps={{ maxLength: 10 }}
                            onChange={(e) => {
                                const val = e.target.value;
                                if (/^\d{0,10}$/.test(val)) setMobileno(val);
                            }}
                        />
                    </Col>
                    <Col span={12}>
                        <FormControl>
                            <FormLabel>Are you a real estate agent?</FormLabel>
                            <RadioGroup
                                row
                                value={isAgent}
                                onChange={(e) => setIsAgent(e.target.value)}
                            >
                                <FormControlLabel value="yes" control={<Radio />} label="Yes" />
                                <FormControlLabel value="no" control={<Radio />} label="No" />
                            </RadioGroup>
                        </FormControl>
                    </Col>
                </Row>

                {isAgent === 'yes' && (
                    <Row gutter={[16, 16]} style={{ marginTop: '10px' }}>
                        <Col span={12}>
                            <Autocomplete
                                options={cityData}
                                getOptionLabel={(option) => option?.cityName || 'Unnamed City'}
                                isOptionEqualToValue={(option, value) => option.cityId === value.cityId}
                                value={selectedCity}
                                onChange={(event, newValue) => setSelectedCity(newValue)}
                                renderInput={(params) => (
                                    <TextField {...params} label="Select City" fullWidth />
                                )}
                            />



                        </Col>
                        <Col span={12}>
                            <Autocomplete
                                options={userType}
                                getOptionLabel={(option) => option?.username || 'Unnamed User Type'}
                                isOptionEqualToValue={(option, value) => option.userId === value.userId}
                                value={whoYouAre}
                                onChange={(event, newValue) => setWhoYouAre(newValue)}
                                renderInput={(params) => (
                                    <TextField {...params} label="Who You Are" fullWidth />
                                )}
                            />


                        </Col>
                    </Row>
                )}

                <FormControlLabel
                    sx={{ mt: 3 }}
                    control={
                        <Checkbox
                            checked={isAgreed}
                            onChange={(e) => setIsAgreed(e.target.checked)}
                        />
                    }
                    label="I agree to the all terms"
                />

                <Box mt={3}>
                    <Button
                        variant="contained"
                        fullWidth
                        onClick={handleSubmit}
                        sx={{ fontWeight: 'bold', textTransform: 'none', fontSize: '16px' }}
                    >
                        Create Account
                    </Button>
                </Box>
            </Box>
        </Box>
    );
};

export default UserEnquiry;
