import React, { useState, useEffect } from "react";
import HeaderNavbar from "../../Components/Navbar/Header/Header";
import Footer from "../../Components/Footer/Footerone";
import AboutUsHeroImg from "../../Components/AboutUs/AboutUsHeroImg/AboutUsHeroImg";
import Mission from "../../Components/AboutUs/Mission/Mission";
import Vision from "../../Components/AboutUs/Vision/Vision";
import StorySection from "../../Components/AboutUs/StorySection/StorySection";
import CoreValues from "../../Components/AboutUs/CoreValues/CoreValues";
import FaqSection from "../../Components/AboutUs/FaqSection/FaqSection";
import Features from "../../Components/AboutUs/Features/Features";
import BlogSection from "../../Components/AboutUs/BlogSection/BlogSection";
import ContactSection from "../../Components/AboutUs/ContactSection/ContactSection";

function AboutUs() {
  const [user, setUser] = useState(null);

  // Fetch saved user from localStorage
  useEffect(() => {
    const storedUser = localStorage.getItem("user");
    if (storedUser) setUser(JSON.parse(storedUser));
  }, []);

  return (
    <>
      <HeaderNavbar user={user} setUser={setUser} />
      <AboutUsHeroImg />
      <Mission />
      <Vision />
      <StorySection />
      <CoreValues />
      <FaqSection />
      <Features />
      <BlogSection />
      <ContactSection />
      <Footer />
      
    </>
  );
}

export default AboutUs;
