import React, { useState, useEffect } from "react";
import PropertyForm from "../../Components/PropertyForm/PropertyForm";
import { Spin } from "antd";
import PropertyForm2 from "../../Components/PropertyForm/PropertyForm2";
import Loading from "../../Components/Loading/Loading";
import { LoadScript } from "@react-google-maps/api";

function PostNewProperty() {
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    // Simulate fetching dashboard data
    const timer = setTimeout(() => {
      setLoading(false);
    }, 1000); // change to API call if needed

    return () => clearTimeout(timer);
  }, []);

  
  return (
    <>
      {/* ✅ Show Loader first */}
      {loading && <Loading fullscreen={true} size={80} />}

      {/* ✅ After loading → Show data */}
      {!loading && (
        <div
          style={{
            maxWidth: "100%",
            margin: "0 auto",
            borderRadius: 16,
            // boxShadow: "0 6px 24px rgba(0, 0, 0, 0.06)",
            marginTop: "0px",
          }}
        >
            {/* <LoadScript googleMapsApiKey="AIzaSyCeGVTNro0CJKJ-C3_GYEqzRZeCWGoBLIU" libraries={["places"]}> */}
          <PropertyForm2 />
          {/* </LoadScript> */}
        </div>
      )}
    </>
  );
}

export default PostNewProperty;
