import React, { useState, useEffect } from "react";
import { Card, Col, Row, Typography, Statistic, Spin } from "antd";
import {
  HomeOutlined,
  UnorderedListOutlined,
  UserSwitchOutlined,
  LineChartOutlined,
} from "@ant-design/icons";
import PackageCard from "../../Components/Package/PackageCard";
import Loading from "../../Components/Loading/Loading";

const { Title, Text } = Typography;

const cardStyle = {
  borderRadius: "12px",
  boxShadow: "0 4px 12px rgba(0,0,0,0.05)",
  transition: "all 0.3s ease",
};

const iconStyle = {
  fontSize: 30,
  padding: 12,
  borderRadius: "50%",
  background: "#f0f2f5",
  marginBottom: 12,
};

const packages = [
  {
    name: "Silver Plan",
    price: "₹999 / month",
    features: [
      "10 Listings",
      "Standard Email Support",
      "7 Days Visibility",
      "Basic Property Insights",
      "Photo Uploads (10 per Listing)",
    ],
    status: "active",
    buttonText: "Renew",
    color: "#1890ff",
  },
  {
    name: "Gold Plan",
    price: "₹1999 / month",
    features: [
      "50 Listings",
      "Priority Support",
      "30 Days Visibility",
      "Ad Boosting (2 per month)",
      "Advanced Analytics",
      "Photo Uploads (25 per Listing)",
      "Featured in Search Results",
    ],
    status: "notSubscribed",
    buttonText: "Upgrade",
    color: "#52c41a",
  },
  {
    name: "Diamond Plan",
    price: "₹4999 / month",
    features: [
      "Unlimited Listings",
      "Dedicated Account Manager",
      "Top Search Visibility",
      "Social Media Promotion",
      "Unlimited Photo Uploads",
      "Custom Property Reports",
      "Buyer Lead Reports",
    ],
    status: "expired",
    buttonText: "Renew",
    color: "#fa8c16",
  },
];

const MyDashboard = () => {
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    // Simulate fetching dashboard data
    const timer = setTimeout(() => {
      setLoading(false);
    }, 1000); // change to API call if needed

    return () => clearTimeout(timer);
  }, []);

  if (loading) return <Loading fullscreen />;

  return (
    <div
      style={{
        padding: 0,
        background: "#f5f7fa",
        minHeight: "auto",
        borderRadius: "12px",
        margin: 10,
      }}
    >
      {/* Gradient Header */}
      <div
        style={{
          background: "linear-gradient(90deg, #0057ff 0%, #1e90ff 100%)",
          padding: "50px 24px",
          borderRadius: 16,
          marginBottom: 32,
          color: "#fff",
        }}
      >
        <Title level={1} style={{ color: "#fff", margin: 0 }}>
          Welcome back, 👋
        </Title>
        <Text level={2} style={{ color: "#e0e0e0" }}>
          Here’s what’s happening with your properties today
        </Text>
      </div>

      {/* Package Section */}
      {/* Package Section */}
      {/* Package Section */}
      {/* <div style={{ marginTop: 40 }}>
        <Row gutter={[24, 24]} justify="center">
          {packages.map((pkg, index) => (
            <Col xs={24} sm={12} md={12} lg={12} xl={6} key={index}>
              <Card
                hoverable
                style={{
                  borderRadius: 16,
                  border:
                    pkg.status === "active"
                      ? `2px solid ${pkg.color}`
                      : "1px solid #e0e0e0",
                  boxShadow:
                    pkg.status === "active"
                      ? "0 6px 20px rgba(0, 87, 255, 0.15)"
                      : "0 4px 12px rgba(0,0,0,0.05)",
                  transition: "all 0.3s ease",
                  padding: 20,
                  textAlign: "center",
                  height: "100%",
                  minHeight: 420, // 🔹 ensures equal card height
                  display: "flex",
                  flexDirection: "column",
                  justifyContent: "space-between",
                  position: "relative",
                }}
              >
               
                {pkg.name === "Gold Plan" && (
                  <div
                    style={{
                      position: "absolute",
                      top: -12,
                      left: "50%",
                      transform: "translateX(-50%)",
                      background: "#52c41a",
                      color: "#fff",
                      fontSize: 12,
                      fontWeight: 600,
                      padding: "4px 12px",
                      borderRadius: 20,
                      boxShadow: "0 2px 6px rgba(0,0,0,0.2)",
                    }}
                  >
                    MOST POPULAR
                  </div>
                )}

              
                <Title level={4} style={{ marginBottom: 10 }}>
                  {pkg.name}
                </Title>

               
                <Text
                  strong
                  style={{ fontSize: 22, display: "block", marginBottom: 16 }}
                >
                  {pkg.price}
                </Text>

               
                <div style={{ marginBottom: 20, flexGrow: 1 }}>
                  {pkg.features.map((f, i) => (
                    <Text
                      key={i}
                      style={{
                        display: "block",
                        margin: "6px 0",
                        color: "#555",
                        fontSize: 14,
                      }}
                    >
                      ✅ {f}
                    </Text>
                  ))}
                </div>


                <button
                  style={{
                    backgroundColor: pkg.color,
                    border: "none",
                    padding: "10px 20px",
                    borderRadius: 8,
                    color: "#fff",
                    fontWeight: 600,
                    cursor: "pointer",
                    width: "100%",
                    transition: "0.3s",
                  }}
                >
                  {pkg.buttonText}
                </button>

               
                {pkg.status === "active" && (
                  <div
                    style={{ marginTop: 10, color: pkg.color, fontWeight: 500 }}
                  >
                    Active Plan
                  </div>
                )}
                {pkg.status === "expired" && (
                  <div
                    style={{ marginTop: 10, color: "#ff4d4f", fontWeight: 500 }}
                  >
                    Expired
                  </div>
                )}
              </Card>
            </Col>
          ))}
        </Row>
      </div> */}

      {/* Info Cards */}
      {/* <Row gutter={[24, 24]} style={{ marginTop: 40 }}>
        <Col xs={24} sm={12} md={12} lg={6}>
          <Card style={cardStyle} hoverable>
            <HomeOutlined style={iconStyle} />
            <Statistic title="Total Properties" value={124} />
          </Card>
        </Col>

        <Col xs={24} sm={12} md={12} lg={6}>
          <Card style={cardStyle} hoverable>
            <UnorderedListOutlined style={iconStyle} />
            <Statistic title="Active Listings" value={57} />
          </Card>
        </Col>

        <Col xs={24} sm={12} md={12} lg={6}>
          <Card style={cardStyle} hoverable>
            <UserSwitchOutlined style={iconStyle} />
            <Statistic title="Buyer Enquiries" value={36} />
          </Card>
        </Col>

        <Col xs={24} sm={12} md={12} lg={6}>
          <Card style={cardStyle} hoverable>
            <LineChartOutlined style={iconStyle} />
            <Statistic title="Views (This Month)" value={842} />
          </Card>
        </Col>
      </Row> */}

      {/* Additional Sections Later: Charts, Recent Listings, etc. */}
    </div>
  );
};

export default MyDashboard;
