import React, { useEffect, useState } from "react";
import { Layout } from "antd";
import { Outlet } from "react-router-dom";
import Sidebar from "./Sidebar";
import HeaderNavbar from "../Components/Navbar/Header/Header";
import { decryptParam } from "../utils/encript";
import axios from "axios";
import { URL } from "../config";

const { Header, Sider, Content } = Layout;

const DashboardLayout = () => {
  const [builderData, setBuilderData] = useState(null);
  const [isMobile, setIsMobile] = useState(window.innerWidth < 1000); // mobile view check
  const [user, setUser] = useState(null);

  const sellerId = localStorage.getItem("sellerId");
  console.log(sellerId);

  useEffect(() => {
    const handleResize = () => setIsMobile(window.innerWidth < 1000);
    window.addEventListener("resize", handleResize);
    return () => window.removeEventListener("resize", handleResize);
  }, []);

  useEffect(() => {
    const fetchBuilder = async () => {
      try {
        const encryptedId = localStorage.getItem("builderId");
        console.log(encryptedId);
        if (!encryptedId) {
          console.warn("No builderId found in localStorage");
          return;
        }

        const decryptedId = decryptParam(encryptedId);
        console.log("Decrypted ID:", decryptedId);

        const response = await axios.get(`${URL}/seller-masters/${sellerId}`);

        console.log("Builder Data:", response.data);
        setBuilderData(response.data);
      } catch (error) {
        console.error("Error fetching builder info:", error);
      }
    };

    fetchBuilder();
  }, []);

  useEffect(() => {
    const storedUser = localStorage.getItem("user");
    if (storedUser) setUser(JSON.parse(storedUser));
  }, []);

  return (
    <>
      {/* Top Header */}
      <Header
       
        style={{
          background: "#0057ff",
          padding: 0,
          height: 64,
          width: "100%",
          position: "fixed",
          top: 0,
          zIndex: 1000,
        }}
      >
        <HeaderNavbar  user={user}
        setUser={setUser} builder={builderData} />
      </Header>

      {/* Sidebar + Page Content */}
      <Layout style={{ marginTop: 55, minHeight: "100vh" }}>
        <Sider
          width={260}
          theme="light"
          breakpoint="lg"
          collapsedWidth="0"
          style={{
            height: "88vh",
            position: "fixed",
            left: 0,
            top: 75,
            borderRadius: "13px",
            margin: "8px",
            zIndex: 1,
          }}
        >
          <Sidebar />
        </Sider>

        <Layout
          style={{
            marginLeft: isMobile ? 0 : 270, // <-- dynamic margin
            width: isMobile ? "100%" : "1100px",
            marginTop: "20px",
          }}
        >
          <Content style={{ padding: 0, background: "#f5f5f5" }}>
            <Outlet context={{ builderData }} />
          </Content>
        </Layout>
      </Layout>
    </>
  );
};

export default DashboardLayout;
