import React, { useState } from "react";
import { Card, Row, Col, Typography } from "antd";
import { FiHome, FiDollarSign, FiGlobe } from "react-icons/fi";
import AccountBalanceIcon from "@mui/icons-material/AccountBalance";
import AccountTreeIcon from "@mui/icons-material/AccountTree";
import InsightsIcon from "@mui/icons-material/Insights";
import AssessmentIcon from "@mui/icons-material/Assessment";
import FeedIcon from "@mui/icons-material/Feed";
import {
  HomeOutlined,
  DollarOutlined,
  GlobalOutlined,
  CustomerServiceOutlined,
  CompassOutlined,
  BankOutlined,
} from "@ant-design/icons";
import { FaHandshake, FaShieldAlt, FaGlobe, FaUsers } from "react-icons/fa";
import { MdSupportAgent, MdExplore, MdRealEstateAgent } from "react-icons/md";
import { HiOutlineBadgeCheck } from "react-icons/hi";
import { motion } from "framer-motion";

const { Title, Paragraph } = Typography;

const services = [
  {
    icon: <MdRealEstateAgent style={{ fontSize: 55, color: "#e91e63" }} />,
    title: "Property Buying & Selling Assistance",
    description: "Verified listings, fair prices, and expert guidance.",
  },
  {
    icon: <AccountBalanceIcon style={{ fontSize: 55, color: "#e91e63" }} />,
    title: "Commercial Property Deals",
    description: "Offices, showrooms, and investment opportunities.",
  },
  {
    icon: <AccountTreeIcon style={{ fontSize: 55, color: "#e91e63" }} />,
    title: "Rental & Leasing Services",
    description: "Helping owners and tenants find the perfect match.",
  },
  {
    icon: <InsightsIcon style={{ fontSize: 55, color: "#e91e63" }} />,
    title: "Real Estate Investment Guidance",
    description: "Market insights and portfolio management.",
  },
  {
    icon: <AssessmentIcon style={{ fontSize: 55, color: "#e91e63" }} />,
    title: "Project Marketing & Branding",
    description: "Helping builders promote new projects effectively.",
  },
  {
    icon: <FeedIcon style={{ fontSize: 55, color: "#e91e63" }} />,
    title: "Legal & Documentation Support",
    description: "Hassle-free paperwork and registration support.",
  },
];

const OurCoreServices = () => {
  // Keep track of expanded cards
  // const [expandedIndex, setExpandedIndex] = useState(null);

  // const toggleExpand = (index) => {
  //   setExpandedIndex(expandedIndex === index ? null : index);
  // };

  return (
    <div style={{ padding: "60px 20px", background: "#f7f7f7" }}>
      <Title
        level={1}
        style={{ textAlign: "center", marginBottom: "58px", fontWeight: 600, fontFamily: "Poppins", }}
      >
        Our Core Services
      </Title>
      {/* <Paragraph
        style={{
          textAlign: "center",
          marginBottom: "40px",
          color: "#555",
          fontWeight: "500",
          fontSize: "20px",
        }}
      >
        Because your property journey deserves a partner who truly cares.
        <br />
        Here’s why clients choose <b> Lello Properties</b>
      </Paragraph> */}

      <Row gutter={[24, 24]} justify="center">
        {services.map((service, index) => (
          <Col xs={24} sm={12} md={8} key={index}>
            <motion.div
              whileHover={{ scale: 1.05 }}
              transition={{ type: "spring", stiffness: 300 }}
            >
              <Card
                bordered={false}
                style={{
                  textAlign: "center",
                  borderRadius: "12px",
                  minHeight: "240px",
                }}
                hoverable
              >
                <div>{service.icon}</div>
                <Title level={4} style={{ marginTop: "16px", fontFamily: "Poppins", }}>
                  {service.title}
                </Title>
                <Paragraph style={{ color: "#666", fontSize: "20px", fontFamily: "Poppins", }}>
                  {/* {expandedIndex === index
                    ? service.description
                    : service.description.slice(0, 100) + "..."} */}
                  {service.description}
                  {/* <span
                    style={{ color: "#e91e63", cursor: "pointer", marginLeft: 4 }}
                    onClick={() => toggleExpand(index)}
                  >
                    {expandedIndex === index ? "Read Less" : "Read More"}
                  </span> */}
                </Paragraph>
              </Card>
            </motion.div>
          </Col>
        ))}
      </Row>
    </div>
  );
};

export default OurCoreServices;
