import React, { useState, useEffect } from "react";
import { Row, Col, Button } from "antd";
import {
  HomeOutlined,
  BankOutlined,
  ApartmentOutlined,
  LineChartOutlined,
  ProjectOutlined,
  FileTextOutlined,
  EnvironmentOutlined,
} from "@ant-design/icons";
import Bg1 from "../../assets/WhatWeAre/image.png"
import Bg2 from "../../assets/WhatWeAre/img4.png"
import Bg3 from "../../assets/WhatWeAre/img5.jpg"



const WhatWeAre = () => {
  const [isMobile, setIsMobile] = useState(false);
  const [isTablet, setIsTablet] = useState(false);

  useEffect(() => {
    const handleResize = () => {
      const width = window.innerWidth;
      setIsMobile(width <= 768);
      setIsTablet(width > 768 && width <= 1024);
    };

    handleResize();
    window.addEventListener("resize", handleResize);
    return () => window.removeEventListener("resize", handleResize);
  }, []);


  const sectionStyle = {
    backgroundImage: !isMobile && !isTablet ? `url(${Bg1})` : "none",
    backgroundSize: "cover",
    backgroundPosition: "center",
    backgroundRepeat: "no-repeat",
    minHeight: "100vh",
    display: "flex",
    flexDirection: "column",
    justifyContent: "space-between",
    color: "white",
    padding: "50px 20px",
  };


  const footerStyle = {
    textAlign: "center",
    background:
      "linear-gradient(to right, #ffffff 0%, #ffffff 50%, #002400 50%, #002400 100%)",
    position: "fixed",
    left: 0,
    bottom: 0,
    width: "100%",
    padding: "5px 0",
  };
  const footerTextStyle = {
    fontSize: "12px",
    padding: "2px 10px",
    margin: 0,
    display: "flex",
    width: "100%",
  };
  const leftFooterSpanStyle = { flex: 1, color: "#000", textAlign: "right" };
  const rightFooterSpanStyle = { flex: 1, color: "#fff", textAlign: "left" };


  const leftSideStyle = {
    backgroundImage: isMobile || isTablet ? `url(${Bg3})` : "none",
    backgroundSize: "cover",
    backgroundPosition: "center",
    borderRadius: "20px",
    padding: "20px",
    color: "#e2d7bc",
  };

  const leftSideH3Style = {
    marginBottom: "20px",
    fontSize: isMobile || isTablet ? "21px" : "25px",
    fontFamily: "'Poppins', sans-serif",
  };
  const servicesListStyle = { listStyle: "none", padding: 0, marginTop: "40px" };
  const servicesListItemStyle = {
    marginBottom: "15px",
    display: "flex",
    alignItems: "center",
    fontSize: "12px",
    fontFamily: "'Poppins', sans-serif",
  };
  const servicesListIconStyle = { marginRight: "10px", color: "#e2d7bc" };
  const visitBtnStyle = {
    backgroundColor: "#e2d7bc",
    color: "#0b1b14",
    marginTop: "20px",
    fontWeight: "bold",
  };


  const rightSideStyle = {
    backgroundImage: isMobile
      ? `url(${Bg2})`
      : isTablet
      ? `url(${Bg2})` 
      : "none",
    backgroundSize: "cover",
    backgroundPosition: "center",
    color: isMobile || isTablet ? "#000" : "white",
    display: "flex",
    flexDirection: "column",
    justifyContent: "space-between",
    padding: "20px",
    minHeight: isMobile || isTablet ? "70vh" : "auto",
  };

  const whatWeDoStyle = {
    color: "orange",
    textAlign: isMobile || isTablet ? "left" : "center",
    marginBottom: "20px",
  };
  const rightPStyle = {
    fontSize: isMobile || isTablet ? "13px" : "14px",
    color: "black",
    fontWeight: 600,
    paddingLeft: isMobile || isTablet ? "5px" : "50px",
    paddingRight: isMobile || isTablet ? "5px" : "40px",
  };


  const propertyCardStyle = {
    display: "flex",
    flexDirection: "column",
    alignItems: "flex-end",
    padding: isMobile || isTablet ? "10px" : "15px",
    gap: "5px",
    background: "transparent",
    borderRadius: "8px",
    marginTop: isMobile || isTablet ? "230px" : "0",
    width: "100%",
  };

  const propertyH3Style = {
    backgroundColor: "#000",
    color: "#fff",
    padding: isMobile || isTablet ? "0 10px" : "0 15px",
    height: isMobile || isTablet ? "30px" : "40px",
    lineHeight: isMobile || isTablet ? "30px" : "40px",
    borderRadius: isMobile || isTablet ? "50%" : "20px 0 0 20px",
    cursor: "pointer",
    margin: 0,
    marginBottom: "20px",
    display: "inline-block",
    alignSelf: "flex-end",
    fontSize: isMobile || isTablet ? "12px" : "14px",
    textAlign: "center",
  };

  const propertyH5Style = {
    color: isMobile || isTablet ? "red" : "#060606",
    padding: "0 15px",
    height: isMobile || isTablet ? "25px" : "40px",
    lineHeight: isMobile || isTablet ? "25px" : "40px",
    fontSize: isMobile || isTablet ? "13px" : "14px",
    display: "block",
    whiteSpace: isMobile || isTablet ? "nowrap" : "normal",
    overflow: isMobile || isTablet ? "hidden" : "visible",
    textOverflow: isMobile || isTablet ? "ellipsis" : "clip",
    margin: 0,
    width: isMobile || isTablet ? "100%" : "auto",
    justifyContent: isMobile || isTablet ? "flex-start" : "flex-end",
  };

  return (
    <div style={sectionStyle}>
      <Row>
        <Col xs={{ span: 24, order: 2 }} md={{ span: 12, order: 1 }} style={leftSideStyle}>
          <h3 style={leftSideH3Style}>Our Core Services:</h3>
          <ul style={servicesListStyle}>
            <li style={servicesListItemStyle}>
              <HomeOutlined style={servicesListIconStyle} /> Property Buying & Selling Assistance — Verified listings, fair prices, and expert guidance.
            </li>
            <li style={servicesListItemStyle}>
              <BankOutlined style={servicesListIconStyle} /> Commercial Property Deals — Offices, showrooms, and investment opportunities.
            </li>
            <li style={servicesListItemStyle}>
              <ApartmentOutlined style={servicesListIconStyle} /> Rental & Leasing Services — Helping owners and tenants find the perfect match.
            </li>
            <li style={servicesListItemStyle}>
              <LineChartOutlined style={servicesListIconStyle} /> Real Estate Investment Guidance — Market insights and portfolio management.
            </li>
            <li style={servicesListItemStyle}>
              <ProjectOutlined style={servicesListIconStyle} /> Project Marketing & Branding — Helping builders promote new projects effectively.
            </li>
            <li style={servicesListItemStyle}>
              <FileTextOutlined style={servicesListIconStyle} /> Legal & Documentation Support — Hassle-free paperwork and registration support.
            </li>
          </ul>
          <Button type="primary" style={visitBtnStyle}>
            Ready to Visit
          </Button>
        </Col>

        <Col xs={{ span: 24, order: 1 }} md={{ span: 12, order: 2 }} style={rightSideStyle}>
          <div>
            <h2 style={whatWeDoStyle}>_What We Do_</h2>
            <p style={rightPStyle}>
              At Sangli Properties, we provide end-to-end real estate solutions — from search to settlement.
            </p>
          </div>

          <div style={propertyCardStyle}>
            <h3 style={propertyH3Style}>2 & 3 BHK | Rs. 64 L</h3>
            <h5 style={propertyH5Style}>
              <EnvironmentOutlined /> 123, Lorem Ipsum, Street no, City name, Country 123456
            </h5>
          </div>
        </Col>
      </Row>

      {/* {!isMobile && !isTablet && (
        <div style={footerStyle}>
          <p style={footerTextStyle}>
            <span style={leftFooterSpanStyle}>123, Lorem Ipsum, Street no, City name</span>
            <span style={rightFooterSpanStyle}>Country 123456 | +0 12345 67890 | info@domainname.com</span>
          </p>
        </div>
      )} */}
    </div>
  );
};



export default WhatWeAre;
