import React, { useEffect, useRef, useState } from "react";
import { Row, Col, Button, Typography } from "antd";
import welimg from "../../assets/WelcomeProperty/WelcomeProperty.png";
import stars from "../../assets/WelcomeProperty/stars.png";
const { Title, Paragraph } = Typography;

const Welcome = () => {
  const [isVisible, setIsVisible] = useState(false);
  const containerRef = useRef(null);

  useEffect(() => {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            setIsVisible(true);
          }
        });
      },
      {
        threshold: 0.2,
      }
    );

    if (containerRef.current) {
      observer.observe(containerRef.current);
    }

    return () => {
      if (containerRef.current) {
        observer.unobserve(containerRef.current);
      }
    };
  }, []);

  const styles = {
    container: {
      width: "100%",
      padding: "80px 40px",
      backgroundColor: "#f5f9fc",
      overflow: "hidden",
      position: "relative",
      zIndex: 1,
    },
    row: {
      maxWidth: "1400px",
      margin: "0 auto",
    },
    imageWrapper: {
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      position: "relative",
    },
    imageCollage: {
      position: "relative",
      width: "100%",
      maxWidth: "550px",
      opacity: isVisible ? 1 : 0,
      transform: isVisible ? "translateX(0)" : "translateX(-80px)",
      transition: "opacity 1s ease, transform 1s ease",
    },
    image: {
      width: "100%",
      height: "auto",
      display: "block",
      borderRadius: "20px",
      transition: "transform 0.5s ease",
    },
    sparkleBase: {
      position: "absolute",
      fontSize: "24px",
      opacity: isVisible ? 1 : 0,
    },
    sparkle1: {
      top: "10%",
      left: "-5%",
      animation: "sparkle 2s ease-in-out infinite",
    },
    sparkle2: {
      top: "5%",
      left: "2%",
      fontSize: "18px",
      animation: "sparkle 2s ease-in-out infinite 0.5s",
    },
    sparkle3: {
      top: "15%",
      left: "-2%",
      fontSize: "16px",
      animation: "sparkle 2s ease-in-out infinite 1s",
    },
    content: {
      display: "flex",
      flexDirection: "column",
      justifyContent: "center",
      padding: "0 20px",
    },
    title: {
      fontSize: "clamp(2rem, 4vw, 3rem)",
      fontFamily: "Poppins",
      color: "#1a1a1a",
      marginBottom: "30px",
      lineHeight: "1.3",
      fontWeight: "600",
      opacity: isVisible ? 1 : 0,
      transform: isVisible ? "translateY(0)" : "translateY(30px)",
      transition: "opacity 0.8s ease 0.2s, transform 0.8s ease 0.2s",
    },
    brandName: {
      color: "#146F99",
      fontWeight: "600",
      fontFamily: "Poppins",
    },
    text: {
      fontFamily: "Poppins",
      fontSize: "16px",
      lineHeight: "1.8",
      color: "#333",
      marginBottom: "35px",
      opacity: isVisible ? 1 : 0,
      transform: isVisible ? "translateY(0)" : "translateY(30px)",
      transition: "opacity 0.8s ease 0.4s, transform 0.8s ease 0.4s",
    },
    button: {
      backgroundColor: "#146F99",
      border: "none",
      borderRadius: "0 25px 0 25px",
      fontSize: "18px",
      padding: "12px 35px",
      height: "auto",
      fontWeight: "500",
      width: "fit-content",
      position: "relative",
      overflow: "hidden",
      opacity: isVisible ? 1 : 0,
      transform: isVisible ? "translateY(0)" : "translateY(30px)",
      transition: "opacity 0.8s ease 0.6s, transform 0.8s ease 0.6s",
    },
  };

  // Media query handling
  const [isMobile, setIsMobile] = useState(false);
  const [isTablet, setIsTablet] = useState(false);

  useEffect(() => {
    const handleResize = () => {
      setIsMobile(window.innerWidth <= 768);
      setIsTablet(window.innerWidth > 768 && window.innerWidth <= 992);
    };

    handleResize();
    window.addEventListener("resize", handleResize);
    return () => window.removeEventListener("resize", handleResize);
  }, []);

  // Responsive styles
  const responsiveStyles = {
    container: {
      ...styles.container,
      padding: isMobile ? "60px 20px" : isTablet ? "60px 20px" : "70px 30px",
    },
    content: {
      ...styles.content,
      padding: isMobile ? "20px 0 0 0" : isTablet ? "20px 5px 0 5px" : "0 10px",
    },
    title: {
      ...styles.title,
      fontSize: isMobile
        ? "1.8rem"
        : isTablet
        ? "2.2rem"
        : "clamp(2rem, 4vw, 3rem)",
    },
    text: {
      ...styles.text,
      fontSize: isMobile || isTablet ? "15px" : "20px",
    },
    button: {
      ...styles.button,
      fontSize: isMobile ? "16px" : "18px",
      padding: isMobile ? "10px 28px" : "12px 35px",
    },
    sparkleBase: {
      ...styles.sparkleBase,
      fontSize: isMobile ? "20px" : "24px",
    },
  };

  return (
    <>
      <style>
        {`
          @keyframes sparkle {
            0%, 100% {
              opacity: 0.3;
              transform: scale(1);
            }
            50% {
              opacity: 1;
              transform: scale(1.2);
            }
          }

          .welcome-image:hover {
            transform: scale(1.02);
          }

          .welcome-button:hover {
            background-color: #0e5577 !important;
            transform: translateY(-3px) scale(1.05);
            box-shadow: 0 6px 20px rgba(20, 111, 153, 0.3);
          }

          .welcome-button:active {
            transform: translateY(-1px) scale(1.02);
          }

          .welcome-button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: left 0.6s ease;
          }

          .welcome-button:hover::before {
            left: 100%;
          }
        `}
      </style>

      <div style={responsiveStyles.container} ref={containerRef}>
        <Row gutter={[60, 40]} align="middle" style={styles.row}>
          {/* Left side - Image */}
          <Col xs={24} lg={12} style={styles.imageWrapper}>
            <div style={styles.imageCollage}>
              <img
                src={welimg}
                alt="Welcome Properties"
                style={styles.image}
                className="welcome-image"
              />
              <div
                style={{ ...responsiveStyles.sparkleBase, ...styles.sparkle1 }}
              >
                <img src={stars} />{" "}
              </div>
              {/* <div style={{...responsiveStyles.sparkleBase, ...styles.sparkle2}}>✨</div>
               */}
            </div>
          </Col>

          {/* Right side - Content */}
          <Col xs={24} lg={12} style={responsiveStyles.content}>
            <Title level={1} style={responsiveStyles.title}>
              Welcome to <span style={styles.brandName}>Lello Properties</span>
            </Title>

            <Paragraph style={responsiveStyles.text}>
              <b>
                At <span style={{ color: "#ff5937" }}> Lello Properties </span>,
                we believe real estate isn't about transactions it's about
                transformation.
              </b>
            </Paragraph>

            <ul
              style={{
                ...responsiveStyles.text,
                marginTop: "10px",
                paddingLeft: "20px",
                listStyleType: "disc",
              }}
            >
              <li style={{ marginBottom: "12px" }}>
                Every property tells a story of dreams, new beginnings, and
                lasting memories.
              </li>
              <li style={{ marginBottom: "12px" }}>
                With more than decade of expertise and a passion for connecting
                people to places, we offer a{" "}
                <b>complete real estate experience</b> from buying and selling
                to renting and investing.
              </li>
              <li style={{ marginBottom: "12px" }}>
                We combine{" "}
                <b>
                  local insight, transparent processes, and modern technology
                </b>{" "}
                to make your property journey effortless, informed, and deeply
                personal.
              </li>
            </ul>

            {/* <Button 
              type="primary" 
              size="large" 
              style={responsiveStyles.button}
              className="welcome-button"
            >
              Read More
            </Button> */}
          </Col>
        </Row>
      </div>
    </>
  );
};

export default Welcome;
