import React from 'react';
import './UpcomingProjects.css';
import buildingImage from '../../assets/buildtwo.jpg';

const projectData = [
    {
        title: 'Pride Platinum',
        description: '3 BHK Apartment in Baner Pune',
        price: '₹ 1.35 - 2.50 Cr',
        tag: 'RERA',
        image: buildingImage,
    },
    {
        title: 'Pride Platinum',
        description: '3 BHK Apartment in Baner Pune',
        price: '₹ 1.35 - 2.50 Cr',
        tag: 'RERA',
        image: buildingImage,
    },
];

const UpcomingProjects = () => {
    return (
        <div className="upcoming-section">
            <div className="upcoming-header">
                <div>
                    <h2>Upcoming Projects</h2>
                    <p>
                        Explore the best property values in upcoming real estate projects
                        tailored for smart investors.
                    </p>
                </div>
                <button className="view-more-btn">View more</button>
            </div>

            <div className="project-cards">
                {projectData.map((project, index) => (
                    <div key={index} className="project-card">
                        <img src={project.image} alt="building" className="project-image" />
                        <div className="project-info">
                            <h3>{project.title}</h3>
                            <p className="desc">{project.description}</p>
                            <p className="price-label">Starting from</p>
                            <p className="price">{project.price}</p>
                            <span className="rera-tag">{project.tag}</span>
                        </div>
                    </div>
                ))}
            </div>
        </div>
    );
};

export default UpcomingProjects;
