import React from "react";
import "./TrySearch.css";
import { motion } from "framer-motion";
import CountUp from "react-countup";
import { useInView } from "react-intersection-observer";
import {
  HomeOutlined,
  ShopOutlined,
  BankOutlined,
  TeamOutlined,
  EnvironmentOutlined,
} from "@ant-design/icons";

import img1 from "../../assets/PostIMG/PostImg_5.jpeg";
import img2 from "../../assets/PostIMG/PostImg_27.jpg";
import img3 from "../../assets/PostIMG/PostImg_28.webp";
import img4 from "../../assets/PostIMG/PostImg_15.jpg";
import img5 from "../../assets/PostIMG/PostImg_16.jpg";

const categories = [
  { img: img1, count: 50, label: "Apartments", icon: <HomeOutlined /> },
  { img: img2, count: 80, label: "Commercial", icon: <ShopOutlined /> },
  { img: img3, count: 100, label: "Houses", icon: <BankOutlined /> },
  { img: img4, count: 60, label: "PG/Co-living", icon: <TeamOutlined /> },
  { img: img5, count: 75, label: "Plots/Lands", icon: <EnvironmentOutlined /> },
];

const TrySearching = () => {
  // Detect when the section is in view
  const { ref, inView } = useInView({
    triggerOnce: true, // run only once
    threshold: 0.9,
  });

  return (
    <div className="ts-container" ref={ref}>
      <motion.div
        className="ts-header"
        initial={{ x: "-100%", opacity: 0 }}
        animate={{ x: 0, opacity: 1 }}
        transition={{ duration: 1.2 }}
      >
        <h2 style={{fontFamily: "Poppins",}}>Try Searching For</h2>
        <p style={{ fontSize: "18px",fontFamily: "Poppins", }}>
          Thousands of luxury home enthusiasts just like you have found their
          dream property.
        </p>
      </motion.div>

      <motion.div className="ts-slider">
        <div className="ts-card-wrapper">
          {categories.map((cat, idx) => (
            <div className="ts-card" key={idx}>
              <img src={cat.img} alt={cat.label} className="ts-img" />
              <div className="ts-overlay">
                <div className="ts-icon">{cat.icon}</div>
                <h3>
                  {inView ? (
                    <CountUp start={0} end={cat.count} duration={3.5} />
                  ) : (
                    0
                  )}
                  +
                </h3>
                <h4>{cat.label}</h4>
              </div>
            </div>
          ))}
        </div>
      </motion.div>
    </div>
  );
};

export default TrySearching;
