// import React, { useEffect, useState } from 'react';
// import Slider from 'react-slick';
// import './TestimonialSection.css';
// import axios from 'axios';
// import { URL } from '../../config';
// import { Box, Typography, Container } from '@mui/material';
// import FormatQuoteIcon from '@mui/icons-material/FormatQuote';

// const TestimonialSection = () => {
//   const [testimonials, setTestimonials] = useState([]);

//   useEffect(() => {
//     const fetchTestimonials = async () => {
//       try {
//         const res = await axios.get(`${URL}/testimonial-masters`);
//         console.log('testimonials:', res.data);
//         setTestimonials(res.data);
//       } catch (error) {
//         console.log(error);
//       }
//     };
//     fetchTestimonials();
//   }, []);

//   const settings = {
//     dots: true,
//     infinite: true,
//     speed: 1000,
//     slidesToShow: 2,
//     slidesToScroll: 1,
//     autoplay: true,
//     autoplaySpeed: 3000,
//     arrows: true,
//     responsive: [
//       {
//         breakpoint: 1024,
//         settings: {
//           slidesToShow: 2,
//         },
//       },
//       {
//         breakpoint: 768,
//         settings: {
//           slidesToShow: 1,
//         },
//       },
//     ],
//   };

//   return (
//     <div className="testimonial-slider-section" style={{backgroundColor:"rgb(214 207 207 / 10%)"}}>
//       {/* MUI Title Section */}
// <Container maxWidth="lg">
//   <Box
//     sx={{
//       textAlign: 'center',
//       py: 2,
//       position: 'relative',
//     }}
//   >
//     {/* Decorative Quote Icon */}
//     {/* <Box
//       sx={{
//         display: 'inline-flex',
//         alignItems: 'center',
//         justifyContent: 'center',
//         mb: 2,
//       }}
//     >
//       <FormatQuoteIcon
//         sx={{
//           fontSize: 50,
//           color: 'primary.main',
//           opacity: 0.3,
//         }}
//       />
//     </Box> */}

//     {/* Main Title */}
//     <Typography
//       variant="h3"
//       component="h2"
//       sx={{
//         fontWeight: 700,
//         color: '#333',
//         mb: 2,
//         fontSize: { xs: '2rem', sm: '2.5rem', md: '3rem' },
//         letterSpacing: '-0.5px',
//       }}
//     >
//       Customer  Reviews
//     </Typography>

//     {/* Decorative Divider */}
//     <Box
//       sx={{
//         width: 80,
//         height: 4,
//         backgroundColor: 'primary.main',
//         margin: '0 auto',
//         mb: 2,
//         borderRadius: 2,
//       }}
//     />

//   </Box>
// </Container>

//       <Slider {...settings}>
//         {testimonials.map((testimonial, index) => (
//           <div className="testimonial-card-wrapper" key={index}>
//             <div className="testimonial-card">
//               <div className="testimonial-content">
//                 <div className="testimonial-left">
//                   <br />
//                   <br />
//                   <p className="hear">{testimonial.sectionTitle}</p>
//                   <h2>{testimonial.sectionSubtitle}</h2>
//                   <div className="stars">{'★'.repeat(testimonial.rating || 0)}</div>
//                   <p className="testimonial-message">{testimonial.testimonialText}</p>
//                   <div className="divider"></div>

//                   <div className="author-info">
//                     <img
//                       src={testimonial.profileImage}
//                       alt={testimonial.customerName}
//                       className="author-image"
//                     />
//                     <div className="author-details">
//                       <h4>{testimonial.customerName}</h4>
//                       <p className="location">{testimonial.customerLocation}</p>
//                     </div>
//                   </div>
//                 </div>

//                 <div className="testimonial-right">
//                   <img
//                     src={testimonial.propertyImage}
//                     alt={testimonial.customerName}
//                     className="testimonial-image"
//                   />
//                 </div>
//               </div>
//             </div>
//           </div>
//         ))}
//       </Slider>
//     </div>
//   );
// };

// export default TestimonialSection;
import React, { useEffect, useState } from "react";
import Slider from "react-slick";
import axios from "axios";
import { URL } from "../../config";
import {
  Box,
  Typography,
  Container,
  Avatar,
  Card,
  CardContent,
} from "@mui/material";
import FormatQuoteIcon from "@mui/icons-material/FormatQuote";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import "./TestimonialSection.css";

const TestimonialSection = () => {
  const [testimonials, setTestimonials] = useState([]);

  useEffect(() => {
    const fetchTestimonials = async () => {
      try {
        const res = await axios.get(`${URL}/testimonial-masters`);
        setTestimonials(res.data);
      } catch (error) {
        console.log(error);
      }
    };
    fetchTestimonials();
  }, []);

  const settings = {
    dots: true,
    infinite: true,
    speed: 1000,
    slidesToShow: 2,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 3500,
    arrows: true,
    responsive: [
       {
        breakpoint: 1200, // tablets
        settings: { slidesToShow: 2 },
      },
      {
        breakpoint: 1024, // tablets
        settings: { slidesToShow: 1 },
      },
      {
        breakpoint: 900, // small tablets
        settings: { slidesToShow: 1, arrows: false },
      },
      {
        breakpoint: 600, // mobile
        settings: { slidesToShow: 1, arrows: false },
      },
    ],
  };

  const TestimonialCard = ({ testimonial }) => (
    <Box sx={{ p: { xs: 1, md: 2 } }}>
      <Card
        sx={{
          display: "flex",
          flexDirection: { xs: "column", sm: "column", md: "row", },
          borderRadius: "12px",
          boxShadow: "0 4px 12px rgba(0,0,0,0.1)",
          bgcolor: "#fff",
          overflow: "hidden",
          height: "100%",
        }}
      >
        {/* Left Side (Text Content) */}
        <CardContent
          sx={{
            flex: 1,
            p: { xs: 2, md: 3 },
            display: "flex",
            flexDirection: "column",
            justifyContent: "space-between",
          }}
        >
          <Box>
            <Typography
              variant="overline"
              sx={{
                color: "orange",
                fontSize: { xs: 12, sm: 13, md: 14 },
                fontFamily: "Poppins",
              }}
            >
              {testimonial.sectionTitle}
            </Typography>
            <Typography
              variant="h5"
              sx={{
                fontSize: { xs: "1.2rem", sm: "1.4rem", md: "1.6rem" },
                mb: 1,
                color: "#432217",
                fontWeight: 600,
                fontFamily: "Poppins",
              }}
            >
              {testimonial.sectionSubtitle}
            </Typography>

            <Box sx={{ color: "#f39c12", fontSize: "1.2rem", mb: 1 }}>
              {"★".repeat(testimonial.rating || 0)}
            </Box>

            <Typography
              variant="body1"
              sx={{
                color: "#444",
                lineHeight: 1.6,
                fontStyle: "italic",
                mb: 2,
                fontFamily: "Poppins",
                display: "-webkit-box",
                WebkitLineClamp: 6, // ✅ limit text to 4 lines
                WebkitBoxOrient: "vertical",
                overflow: "hidden",
                textOverflow: "ellipsis",
                minHeight: { xs: 90, sm: 100, md: 150 }, // ✅ reserve fixed height space
              }}
            >
              <FormatQuoteIcon sx={{ fontSize: 20, mr: 1, color: "#f39c12" }} />
              {testimonial.testimonialText}
            </Typography>
          </Box>

          <Box
            sx={{
              display: "flex",
              alignItems: "center",
              gap: "15px",
              pt: 2,
              borderTop: "1px solid #eee",
            }}
          >
            <Avatar
              alt={testimonial.customerName}
              src={testimonial.profileImage}
              sx={{ width: 60, height: 60, border: "2px solid #ddd" }}
            />
            <Box>
              <Typography
                variant="h6"
                sx={{ fontWeight: "bold", color: "#111", lineHeight: 1 }}
              >
                {testimonial.customerName}
              </Typography>
              <Typography
                variant="body2"
                sx={{ fontSize: "0.9rem", color: "#777" }}
              >
                {testimonial.customerLocation}
              </Typography>
            </Box>
          </Box>
        </CardContent>

        {/* Right Side (Image) */}
        <Box
          sx={{
            flex: { xs: "none", md: "0 0 310px" },
            display: "flex",
            justifyContent: "center",
            alignItems: "center",
            p: { xs: 2, md: 0 },
            order: { xs: -1, md: 1 },
            backgroundColor: "#fff",
            mr: { sm: 0, md: 2 },
          }}
        >
          <Box
            component="img"
            src={testimonial.propertyImage}
            alt={testimonial.customerName}
            sx={{
              width: { xs: "100%", sm: "85%", md: "100%" },
              height: { xs: 200, sm: 250, md: 410 },
              borderRadius: { xs: "8px", md: "0 12px 12px 0" },
              objectFit: "cover",
              boxShadow: { xs: "0 2px 5px rgba(0,0,0,0.1)", md: "none" },
            }}
          />
        </Box>
      </Card>
    </Box>
  );

  return (
    <Box sx={{ bgcolor: "rgb(214 207 207 / 10%)", py: { xs: 4, md: 8 } }}>
      {/* Title Section */}
      <Container maxWidth="lg">
        <Box sx={{ textAlign: "center", py: 2 }}>
          <Typography
            variant="h3"
            sx={{
              fontWeight: 700,
              color: "#333",
              mb: 2,
              fontSize: { xs: "1.8rem", sm: "2.5rem", md: "3rem" },
              fontFamily: "Poppins",
            }}
          >
            Customer Reviews
          </Typography>
          <Box
            sx={{
              width: 80,
              height: 4,
              backgroundColor: "primary.main",
              margin: "0 auto",
              mb: 2,
              borderRadius: 2,
            }}
          />
        </Box>
      </Container>

      {/* Slider */}
      <Container maxWidth="xl" sx={{ p: 0 }}>
        {testimonials.length > 0 ? (
          <Box className="testimonial-slider-wrapper">
            <Slider {...settings}>
              {testimonials.map((testimonial, index) => (
                <TestimonialCard testimonial={testimonial} key={index} />
              ))}
            </Slider>
          </Box>
        ) : (
          <Typography textAlign="center" color="text.secondary">
            No testimonials found.
          </Typography>
        )}
      </Container>
    </Box>
  );
};

export default TestimonialSection;
