// import React from "react";
// import { motion } from "framer-motion";
// import "./RealEstateBlogs.css";

// import img1 from "../../assets/PostIMG/PostImg_13.avif";
// import img2 from "../../assets/PostIMG/PostImg_15.jpg";
// import img3 from "../../assets/PostIMG/PostImg_17.jpg";
// import img4 from "../../assets/PostIMG/PostImg_28.webp"; // fixed typo (.webp)

// // Create an array of fallback images
// const fallbackImages = [img1, img2, img3, img4];

// const RealEstateBlogs = ({ projectData = [], mainProperty }) => {
//   return (
//     <div className="reb-section">
//       <div className="reb-header">
//         <h2>Real Estate Blogs & News</h2>
//         <p>Instant Updates</p>
//       </div>

//       <div className="reb-container">
//         {/* Left Main Blog Card */}
//         {mainProperty && (
//           <motion.div
//             className="reb-main-card"
//             initial={{ x: -100, opacity: 0 }}
//             whileInView={{ x: 0, opacity: 1 }}
//             viewport={{ once: false, amount: 0.3 }}
//             transition={{ duration: 0.8 }}
//           >
//             <img
//               src={mainProperty.image || fallbackImages[0]} // 👈 fallback image
//               alt={mainProperty.title}
//               className="reb-main-img"
//               onError={(e) => (e.target.src = fallbackImages[0])} // 👈 fallback if broken
//             />
//             <div className="reb-main-content">
//               <span className="reb-date">{mainProperty.date}</span>
//               <h3>{mainProperty.title}</h3>
//               <p>{mainProperty.details}</p>
//               <button className="reb-btn">{mainProperty.extra}</button>
//             </div>
//           </motion.div>
//         )}

//         {/* Right Side Blog Cards */}
//         <div className="reb-side-blogs">
//           {projectData.map((blog, index) => (
//             <motion.div
//               key={index}
//               className="reb-side-card"
//               initial={{ x: 100, opacity: 0 }}
//               whileInView={{ x: 0, opacity: 1 }}
//               viewport={{ once: false, amount: 0.3 }}
//               transition={{ duration: 0.6, delay: index * 0.2 }}
//             >
//               <img
//                 src={
//                   blog.image ||
//                   fallbackImages[(index + 1) % fallbackImages.length]
//                 } // 👈 fallback
//                 alt={blog.title}
//                 className="reb-side-img"
//                 onError={(e) =>
//                   (e.target.src =
//                     fallbackImages[(index + 1) % fallbackImages.length])
//                 }
//               />
//               <div className="reb-side-content">
//                 <span className="reb-date">{blog.date}</span>
//                 <h4>{blog.title}</h4>
//                 <p className="truncate">{blog.description}</p>
//                 <div className="reb-meta">
//                   <span className="reb-price">Starting from {blog.price}</span>
//                   <span className="reb-rera">{blog.tag}</span>
//                 </div>
//                 <button className="reb-btn">{blog.extra}</button>
//               </div>
//             </motion.div>
//           ))}
//         </div>
//       </div>
//     </div>
//   );
// };

// export default RealEstateBlogs;

import React from "react";
import {
  Box,
  Grid,
  Card,
  CardContent,
  CardMedia,
  Typography,
  Button,
  Stack,
  Chip,
} from "@mui/material";
import { motion } from "framer-motion";
import img1 from "../../assets/PostIMG/PostImg_13.avif";
import img2 from "../../assets/PostIMG/PostImg_15.jpg";
import img3 from "../../assets/PostIMG/PostImg_17.jpg";
import img4 from "../../assets/PostIMG/PostImg_28.webp";
import "./RealEstateBlogs.css";

const fallbackImages = [img1, img2, img3, img4];

const RealEstateBlogs = ({ projectData = [], mainProperty }) => {
  return (
    <Box
      sx={{
        py: { xs: 4, md: 8 },
        px: { xs: 2, sm: 4, md: 8 },
        background: "linear-gradient(to bottom, #ffffff 0%, #f9fcff 100%)",
      }}
    >
      {/* ===== Header ===== */}
      <Box mb={5}>
        <Typography
          variant="h4"
          sx={{
            fontWeight: 700,
            color: "#222",
            mb: 1,
            textAlign: { xs: "center", md: "left" },
            fontFamily: "Poppins",
          }}
        >
          Real Estate Blogs & News
        </Typography>
        <Typography
          variant="subtitle1"
          sx={{
            color: "#555",
            fontWeight: 500,
            textAlign: { xs: "center", md: "left" },
            fontFamily: "Poppins",
          }}
        >
          Instant Updates
        </Typography>
      </Box>

      {/* ===== Grid Layout ===== */}
      <Grid container spacing={1.5}>
        {/* ===== Left Main Blog ===== */}
        {mainProperty && (
          <Grid item xs={12} md={4}>
            <motion.div whileHover={{ scale: 1.02 }}>
              <Card
                sx={{
                  borderRadius: 4,
                  boxShadow: "0 6px 20px rgba(0,0,0,0.08)",
                   maxWidth: 700
                }}
              >
                <CardMedia
                  component="img"
                  image={mainProperty.image || fallbackImages[0]}
                  alt={mainProperty.title}
                  onError={(e) => (e.target.src = fallbackImages[0])}
                  sx={{
                    height: { xs: 250, sm: 350, md: 570 },
                    objectFit: "cover",
                    
                  }}
                />
                <CardContent sx={{ p: 3 }}>
                  <Typography
                    variant="caption"
                    sx={{ color: "#e67e22", display: "block", mb: 1, fontFamily: "Poppins", }}
                  >
                    {mainProperty.date}
                  </Typography>
                  <Typography
                    variant="h6"
                    sx={{ fontWeight: 600, color: "#222", mb: 1, fontFamily: "Poppins", }}
                  >
                    {mainProperty.title}
                  </Typography>
                  <Typography
                    variant="body2"
                    sx={{ color: "#555", mb: 2, lineHeight: 1.6, maxWidth: 600, fontFamily: "Poppins", }}
                  >
                    {mainProperty.details}
                  </Typography>
                  <Button
                    size="small"
                    sx={{
                      color: "#e67e22",
                      fontWeight: 600,
                      textTransform: "none",
                      fontFamily: "Poppins",
                    }}
                  >
                    Read More
                  </Button>
                </CardContent>
              </Card>
            </motion.div>
          </Grid>
        )}

        {/* ===== Right Blogs ===== */}
        <Grid item xs={12} md={4}>
          <Stack spacing={3}>
            {projectData.map((blog, index) => (
              <motion.div key={index} whileHover={{ scale: 1.02 }}>
                <Card
                  sx={{
                    display: "flex",
                    flexDirection: { xs: "column", sm: "row" },
                    borderRadius: 3,
                    boxShadow: "0 4px 12px rgba(0,0,0,0.08)",
                    
                  }}
                >
                  <CardMedia
                    component="img"
                    image={
                      blog.image ||
                      fallbackImages[(index + 1) % fallbackImages.length]
                    }
                    alt={blog.title}
                    onError={(e) =>
                      (e.target.src =
                        fallbackImages[(index + 1) % fallbackImages.length])
                    }
                    sx={{
                      width: { xs: "100%", sm: 200 },
                      height: { xs: 180, sm: 200 },
                      objectFit: "cover",
                      mt: 2,
                      ml: 1,
                      borderRadius: 2,
                    }}
                  />

                  <CardContent
                    sx={{
                      flex: 1,
                      display: "flex",
                      flexDirection: "column",
                      justifyContent: "space-between",
                      p: 2,
                    }}
                  >
                    <Box>
                      <Typography
                        variant="caption"
                        sx={{ color: "#e67e22", mb: 0, display: "block", fontFamily: "Poppins", }}
                      >
                        {blog.date}
                      </Typography>
                      <Typography
                        variant="subtitle1"
                        sx={{
                          fontWeight: 600,
                          color: "#222",
                          mb: 0,
                          fontSize: "1rem",
                          fontFamily: "Poppins",
                          width: "380px"
                        }}
                      >
                        {blog.title}
                      </Typography>
                      <Typography
                        variant="body2"
                        sx={{
                          color: "#555",
                          mb: 0,
                          fontSize: "0.9rem",
                          lineHeight: 1.5,
                          maxWidth: 300,
                          fontFamily: "Poppins",
                        }}
                      >
                        {blog.description}
                      </Typography>
                    </Box>

                    <Box
                      display="flex"
                      justifyContent="space-between"
                      alignItems="center"
                      flexWrap="wrap"
                      gap={0}
                    >
                      <Typography
                        variant="body2"
                        sx={{
                          color: "#333",
                          fontWeight: 500,
                          fontSize: "0.9rem",
                          fontFamily: "Poppins",
                        }}
                      >
                        Starting from {blog.price}
                      </Typography>
                      <Chip
                        label={blog.tag || "RERA"}
                        sx={{
                          backgroundColor: "#e67e22",
                          color: "#fff",
                          fontSize: "0.75rem",
                          borderRadius: "12px",
                          fontFamily: "Poppins",
                        }}
                      />
                    </Box>

                    <Button
                      size="small"
                      sx={{
                        color: "#e67e22",
                        fontWeight: 600,
                        textTransform: "none",
                        mt: 0,
                        alignSelf: "flex-start",
                        fontFamily: "Poppins",
                      }}
                    >
                      Read More
                    </Button>
                  </CardContent>
                </Card>
              </motion.div>
            ))}
          </Stack>
        </Grid>
      </Grid>
    </Box>
  );
};

export default RealEstateBlogs;
