
import React from 'react';
import './PropertyShowcase.css';
import img1 from '../../assets/buildtwo.jpg';
import img2 from '../../assets/buildtwo.jpg';
import img3 from '../../assets/buildtwo.jpg';
import img4 from '../../assets/buildtwo.jpg';
import img5 from '../../assets/buildtwo.jpg';


const categories = [
    { img: img1, count: 50, label: 'Apartments' },
    { img: img2, count: 80, label: 'Commercial' },
    { img: img3, count: 100, label: 'Houses' },
    { img: img4, count: 60, label: 'PG/C-living' },
    { img: img5, count: 75, label: 'Plots/Lands' },
];

const projectData = [
    {
        title: 'Pride Platinum',
        description: '3 BHK Apartment in Baner Pune',
        price: '₹ 1.35 - 2.50 Cr',
        tag: 'RERA',
        image: img1,
    },
    {
        title: 'Pride Platinum',
        description: '3 BHK Apartment in Baner Pune',
        price: '₹ 1.35 - 2.50 Cr',
        tag: 'RERA',
        image: img2,
    },
];

const PropertyShowcase = () => {
    return (
        <div className="property-showcase">


            <section className="search-section">
                <div className="search-header">
                    <h2>Try Searching For</h2>
                    <p>Thousands of luxury home enthusiasts just like you have inthis found their dream home</p>
                </div>

                <div className="category-cards">
                    {categories.map((cat, index) => (
                        <div className="category-card" key={index}>
                            <img src={cat.img} alt={cat.label} className="category-img" />
                            <div className="category-overlay">
                                <h3>{cat.count}</h3>
                                <p>{cat.label}</p>
                            </div>
                        </div>
                    ))}
                </div>
            </section>


            <section className="upcoming-section">
                <div className="upcoming-header">
                    <div>
                        <h2>Upcoming Projects</h2>
                        <p>
                            Explore the best property in values in upcoming real estate projects tailored for smart in investors.
                        </p>
                    </div>
                    <button className="view-more-btns">View more</button>
                </div>

                <div className="project-cards">
                    {projectData.map((project, index) => (
                        <div key={index} className="project-card">
                            <img src={project.image} alt="building" className="project-image" />
                            <div className="project-info">
                                <h3 className='title'>{project.title}</h3>
                                <p className="desc">{project.description}</p>
                                <p className="price-label">Starting from</p>
                                <p className="price">{project.price}</p>
                                <span className="rera-tag">{project.tag}</span>
                            </div>
                        </div>
                    ))}
                </div>
            </section>
        </div>
    );
};

export default PropertyShowcase;






