import React, { useState } from "react";
import {
  Card,
  Typography,
  Divider,
  Button,
  Row,
  Col,
  Image,
  Modal,
} from "antd";

const { Title, Text, Link } = Typography;

const PropertyAdd = () => {
  const allHighlights = [
    "Features only 42 expansive residences, offering rare exclusivity and a sense of calm within the city.",
    "Rooftop amenities include a gym, yoga deck, gazebo, co-working space, open-air cinema, and a secured community for leisure and recreation.",
    "Spacious 2, 3, and 4 BHK apartments designed to surpass market standards, providing ample space, natural light, and seamless living.",
    "Vastu-compliant layout with natural ventilation throughout the home.",
    "Well-connected to schools, hospitals, and major roads in the city.",
    "State-of-the-art security system with CCTV and biometric access.",
    "Environment-friendly building with solar panels and rainwater harvesting.",
  ];

  const [isModalOpen, setIsModalOpen] = useState(false);

  const openModal = () => setIsModalOpen(true);
  const closeModal = () => setIsModalOpen(false);

  return (
    <>
      <Card
        style={{ maxWidth: 400, margin: "auto" }}
        title={
          <Title level={4}>
            🏠 Why you should consider <br />
            <Text strong style={{ color: "#002766" }}>
              Bedekar Dhanashree Svasti?
            </Text>
          </Title>
        }
      >
        {/* First 3 bullets */}
        <ul style={{ paddingLeft: "1.2rem" }}>
          {allHighlights.slice(0, 3).map((item, index) => (
            <li key={index} style={{ marginBottom: "0.5rem" }}>
              {item}
            </li>
          ))}
        </ul>

        <Link onClick={openModal} style={{ display: "block", marginTop: 10 }}>
          View 4 more →
        </Link>

        <Divider />

        <Row justify="space-between" align="middle">
          <Col>
            <Text type="secondary" style={{ fontSize: "12px" }}>
              DEVELOPED BY
            </Text>
            <br />
            <Text strong>BEDEKAR LIFESPACES LLP</Text>
          </Col>
          <Col>
            <Image
              src="https://via.placeholder.com/80x40?text=Logo"
              alt="Developer Logo"
              preview={false}
              height={40}
            />
          </Col>
        </Row>
        <Row>
          <Button type="primary" ghost block style={{ marginTop: 16 }}>
            Contact Builder
          </Button>
        </Row>
      </Card>

      {/* Modal for all highlights */}
      <Modal
        title={
          <Title level={4}>
            🏠 Why you should consider <br />
            <Text strong style={{ color: "#002766" }}>
              Bedekar Dhanashree Svasti?
            </Text>
          </Title>
        }
        open={isModalOpen}
        onCancel={closeModal}
        footer={null}
        closable={true}
        style={{
          top: 0,
          right: 0,
          margin: 0,
          padding: 0,
          height: "100vh",
          width: "40%", // or '100%' if you want full width on mobile
          maxWidth: "350px",
          position: "fixed",
        }}
        bodyStyle={{
          height: "400px",
          overflowY: "auto",
          padding: "1rem",
        }}
        maskStyle={{
          backgroundColor: "rgba(0,0,0,0.3)", // Optional: dim background
        }}
        width="100%"
        destroyOnClose
        centered={false}
      >
        <ul style={{ paddingLeft: "1.2rem" }}>
          {allHighlights.map((item, index) => (
            <li key={index} style={{ marginBottom: "0.5rem" }}>
              {item}
            </li>
          ))}
        </ul>
      </Modal>
    </>
  );
};

export default PropertyAdd;
