import React, { useState } from "react";
import { Card, Input, Button, Typography } from "antd";
import { HomeOutlined, EnvironmentOutlined } from "@ant-design/icons";

const { Title } = Typography;

function Neighbourhood() {
  const [location, setLocation] = useState("");

  return (
    <div
      id="neighbourhood"
      style={{ padding: "40px 20px", maxWidth: "1500px", margin: "0 auto" }}
    >
      <Title
        level={2}
        style={{
          marginBottom: "30px",
          borderBottom: "3px solid #000",
          display: "inline-block",
          paddingBottom: "5px",
          fontFamily: "Poppins",
        }}
      >
        Neighbourhood
      </Title>

      <Card
        style={{
          borderRadius: "8px",
          boxShadow: "0 2px 8px rgba(0,0,0,0.1)",
        }}
      >
        {/* Location Input Section */}
        <div
          style={{
            display: "flex",
            flexDirection: window.innerWidth < 768 ? "column" : "row",
            gap: "15px",
            marginBottom: "20px",
            alignItems: window.innerWidth < 768 ? "stretch" : "center",
          }}
        >
          <div
            style={{
              display: "flex",
              alignItems: "center",
              gap: "10px",
              flex: 1,
            }}
          >
            <HomeOutlined style={{ fontSize: "24px", color: "#faad14" }} />
            <span
              style={{
                fontWeight: "600",
                whiteSpace: "nowrap",
                fontFamily: "Poppins",
              }}
            >
              Your Location -
            </span>
          </div>
        </div>

        {/* Map Section */}
        <div
          style={{
            width: "100%",
            height: "400px",
            borderRadius: "8px",
            overflow: "hidden",
            position: "relative",
          }}
        >
          <iframe
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3672.6744990417715!2d74.24298807514906!3d16.678374084092933!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3bc10195cce93663%3A0x8c7cc885f1af1570!2sComtranse%20Technology%20kolhapur!5e1!3m2!1sen!2sin!4v1764659781552!5m2!1sen!2sin"
            width="100%"
            height="100%"
            style={{ border: 0 }}
            allowFullScreen=""
            loading="lazy"
            referrerPolicy="no-referrer-when-downgrade"
            title="Neighbourhood Map"
          />
        </div>
      </Card>
    </div>
  );
}

export default Neighbourhood;
