import React, { useState } from "react";
import { Card, Row, Col, Button, Typography, Divider } from "antd";

const { Title, Text } = Typography;

function MoreDetails({ property }) {
  const [showMore, setShowMore] = useState(false);

  // Convert number to Lakh / Crore format
  const formatIndianPrice = (amount) => {
    if (!amount || isNaN(amount)) return "N/A";

    if (amount >= 10000000) {
      return `${(amount / 10000000).toFixed(2)} Cr`;
    }
    if (amount >= 100000) {
      return `${(amount / 100000).toFixed(2)} Lakh`;
    }

    return amount.toString();
  };

  const addressParts = [
    property?.housenumber,
    property?.apartmentNameAreaName,
    property?.sublocality,
    property?.fklocalityId,
    property?.fkcityId,
  ];

  const floorText =
    property?.fkfloorId && property?.totalfloor
      ? `${property.fkfloorId} out of ${property.totalfloor}`
      : property?.fkfloorId
      ? property.fkfloorId
      : "N/A";

  // Filter null/empty values and join without extra commas
  const fullAddress = addressParts.filter(Boolean).join(", ") || "N/A";

  const primaryDetails = [
    {
      label: "Sale Value",
      value: property?.price ? `₹ ${formatIndianPrice(property.price)}` : "N/A",
    },

    {
      label: "Price per Sq.ft",
      value: property?.pricepersqft
        ? `₹ ${formatIndianPrice(property.pricepersqft)}/sq.ft`
        : "N/A",
    },
    {
      label: "Property Type",
      value: property?.noofbedrooms
        ? `${property.noofbedrooms} BHK Flat`
        : "N/A",
    },
    { label: "City", value: property?.fkcityId || "N/A" },
    { label: "Address", value: fullAddress },
    { label: "Built-up Area", value: `${property?.builduparea || 0} sq.ft` },

    {
      label: "Floor",
      value: floorText,
    },
  ];

  const additionalDetails = [
    // { label: "Facing", value: property?.facing.facingName || "N/A" },
    {
      label: "Transaction Type",
      value: property?.fktransactionId === 1 ? "Resale" : "New Booking",
    },
    // {
    //   label: "Possession",
    //   value: property?.possessionType.possessionName || "N/A",
    // },
    {
      label: "Furnishing",
      value:
        property?.fkfurnishingtypeId === 1
          ? "Semi-Furnished"
          : "Fully Furnished",
    },
    { label: "Bedrooms", value: property?.noofbedrooms || 0 },
    { label: "Bathrooms", value: property?.noofbathrooms || 0 },
    { label: "Balconies", value: property?.noofbalkanies || 0 },
    { label: "Carpet Area", value: `${property?.carpetarea || 0} sq.ft` },
    {
      label: "Super Built-up Area",
      value: `${property?.supperbuilduparea || 0} sq.ft`,
    },
    { label: "Total Floors", value: property?.totalfloor || "N/A" },
    { label: "Floor No.", value: property?.fkfloorId || "N/A" },
  ];

  const description =
    property?.Property_Description ||
    `This property is located in ${property?.fklocalityId || "Area"}, ${
      property?.fkcityId || "City"
    }. Carpet area is ${property?.carpetarea || "---"} sq.ft. Title: ${
      property?.Property_Title || "N/A"
    }`;

  return (
    <Card
      id="more-details"
      style={{
        borderRadius: "12px",
        boxShadow: "0 2px 8px rgba(0,0,0,0.1)",
        margin: "20px 22px",
        maxWidth: "1500px",
        fontFamily: "Poppins", // 👈 ADDED HERE
      }}
      bodyStyle={{ padding: "24px", fontFamily: "Poppins" }} // 👈
    >
      <Title
        level={2}
        style={{ marginBottom: "24px", fontFamily: "Poppins" }} // 👈
      >
        More Details
      </Title>

      {/* Primary Details */}
      <Row gutter={[16, 24]}>
        {primaryDetails.map((detail, index) => (
          <Col xs={24} sm={24} md={24} key={index}>
            <Row gutter={16}>
              <Col xs={24} sm={8} md={6}>
                <Text
                  type="secondary"
                  style={{
                    fontSize: "16px",
                    fontWeight: "500",
                    fontFamily: "Poppins", // 👈
                  }}
                >
                  {detail.label}
                </Text>
              </Col>

              <Col xs={24} sm={16} md={18}>
                <Text
                  style={{
                    fontSize: "16px",
                    fontWeight: "600",
                    color: "#000",
                    fontFamily: "Poppins", // 👈
                  }}
                >
                  {detail.value}
                </Text>
              </Col>
            </Row>
          </Col>
        ))}
      </Row>

      {/* View More Section */}
      {showMore && (
        <>
          <Divider />

          <Row gutter={[16, 24]}>
            {additionalDetails.map((detail, index) => (
              <Col xs={24} sm={24} md={24} key={index}>
                <Row gutter={16}>
                  <Col xs={24} sm={8} md={6}>
                    <Text
                      type="secondary"
                      style={{
                        fontSize: "16px",
                        fontWeight: "500",
                        fontFamily: "Poppins", // 👈
                      }}
                    >
                      {detail.label}
                    </Text>
                  </Col>

                  <Col xs={24} sm={16} md={18}>
                    <Text
                      style={{
                        fontSize: "16px",
                        fontWeight: "600",
                        fontFamily: "Poppins", // 👈
                      }}
                    >
                      {detail.value}
                    </Text>
                  </Col>
                </Row>
              </Col>
            ))}
          </Row>
        </>
      )}

      {/* View More Button */}
      <Row style={{ margin: "24px 0" }}>
        <Col>
          <Button
            type="default"
            style={{
              borderRadius: "6px",
              fontWeight: "600",
              fontFamily: "Poppins", // 👈
            }}
            onClick={() => setShowMore(!showMore)}
          >
            {showMore ? "View Less" : "View More"}
          </Button>
        </Col>
      </Row>

      <Divider />

      {/* Description */}
      <Row gutter={[16, 16]}>
        <Col span={24}>
          <Text
            style={{
              fontSize: "16px",
              lineHeight: "1.6",
              fontFamily: "Poppins", // 👈
            }}
          >
            <Text strong style={{ fontFamily: "Poppins" }}>
              Description:{" "}
            </Text>
            {description}
          </Text>
        </Col>
      </Row>
    </Card>
  );
}

export default MoreDetails;
