import React, { useState } from "react";
import { Tabs, Card, Row, Col, Typography, Image, Button, Tag } from "antd";
import {
  DownOutlined,
  UpOutlined,
  PhoneOutlined,
  HeartOutlined,
} from "@ant-design/icons";
import img from "../../assets/images/propertyimgb.jpg";
import twobhk from "../../assets/images/2bhkfloor1.jpeg";
import twobhk1 from "../../assets/images/2bhkfloor2.jpeg";
import threebhk1 from "../../assets/images/3bhk1.webp";
import threebhk2 from "../../assets/images/3bhk2.jpeg";
import fourbhk from "../../assets/images/4bhk1.jpg";
import fourbhk2 from "../../assets/images/4-BHK-4.webp";
import gym from "../../assets/images/gym.png";
import perking from "../../assets/images/parking.png";
import compound from "../../assets/images/compound.png";
import sitout from "../../assets/images/seatout.png";
import water from "../../assets/images/water.png";
import securitty from "../../assets/images/security.png";
import sellerimg from "../../assets/images/sellerimg.png";
import FAQSection from "../../Components/PropertyInfo/FAQSection";
import ArticalSection from "../../Components/PropertyInfo/ArticalSection";
const { Title, Paragraph, Text } = Typography;
const { TabPane } = Tabs;
const floorPlans = {
  "2 BHK": [
    {
      areaSqFt: "811",
      areaSqM: "75.34",
      image: twobhk,
    },
    {
      areaSqFt: "828",
      areaSqM: "76.92",
      image: twobhk1,
    },
  ],
  "3 BHK": [
    {
      areaSqFt: "1014",
      areaSqM: "94.2",
      image: threebhk1,
    },
    {
      areaSqFt: "1021",
      areaSqM: "94.85",
      image: threebhk2,
    },
  ],
  "4 BHK": [
    {
      areaSqFt: "1626",
      areaSqM: "151.06",
      image: fourbhk,
    },
    {
      areaSqFt: "1919",
      areaSqM: "178.28",
      image: fourbhk2,
    },
  ],
};

const facilities = [
  { icon: gym },
  { icon: perking },
  { icon: compound },
  { icon: sitout },
  { icon: water },
  { icon: securitty },
];

const FloorPlansSection = () => {
  const [activeTab, setActiveTab] = useState("2 BHK");

  const items = Object.keys(floorPlans).map((type) => ({
    key: type,
    label: `${type} Apartment`,
    children: (
      <>
        <Text type="secondary" style={{ marginBottom: 12, display: "block" }}>
          {floorPlans[type].length} Floor Plans Available
        </Text>
        <Row gutter={[16, 16]}>
          {floorPlans[type].map((plan, index) => (
            <Col xs={24} sm={12} md={8} lg={6} key={index}>
              <Card
                hoverable
                style={{ borderRadius: 8 }}
                bodyStyle={{ padding: 16 }}
              >
                <div style={{ marginBottom: 8 }}>
                  <Title level={5} style={{ margin: 0 }}>
                    {plan.areaSqFt} <Text type="secondary">sq.ft.</Text>{" "}
                    <Text type="secondary" style={{ fontWeight: "normal" }}>
                      ({plan.areaSqM} sq.m.)
                    </Text>
                  </Title>
                  <Text type="secondary">Carpet Area | {type}</Text>
                </div>
                <Image
                  alt="floor plan"
                  src={plan.image}
                  width="100%"
                  height={180}
                  style={{ objectFit: "cover", borderRadius: 4 }}
                />
                <div style={{ marginTop: 12 }}>
                  <Text strong style={{ fontSize: 16 }}>
                    Price on request
                  </Text>
                </div>
              </Card>
            </Col>
          ))}
        </Row>
      </>
    ),
  }));

  const [expanded, setExpanded] = useState(false);

  const fullText = `Bedekar Lifespaces LLP, a partnership between Bedekar Builders and Siddhant Infrastructure, is a leading real estate developer in Kolhapur with over 15 years of experience. They have completed more than 400 units and focus on various segments such as plotting, commercial development, and housing.`;

  const toggleExpand = () => setExpanded(!expanded);

  return (
    <>
      <div
        id="floor-plans"
        style={{ padding: "4rem", backgroundColor: "#f9fcff" }}
      >
        <Title level={3}>Floor Plans & Pricing</Title>
        <Tabs
          defaultActiveKey="2 BHK"
          activeKey={activeTab}
          onChange={setActiveTab}
          type="card"
          items={items}
        />
      </div>

      {/* seller info */}

      <div id="sellers">
        <Row>
          <Title>Sellers you may contact for more details</Title>
          <Col>
            <img src={sellerimg} />
          </Col>
        </Row>
      </div>

      {/* facilitiesinfo */}
      <div id="facilities">
        <Row>
          <Row justify="space-between" align="middle" style={{ margin: 24 }}>
            <Col>
              <Title level={4} style={{ marginBottom: 4 }}>
                Top Facilities
              </Title>
              <Text type="secondary">
                Bedekar Dhanashree Svasti Kolhapur presents an exclusive
                opportunity to own a stunning home that offers all kinds of
                amenities and facilities. This includes a gymnasium, sit out
                area, and easy access to car parking. It also has a gated
                community, an exclusive offering only for Bedekar Dhanashree
                Svasti residents. Bedekar Dhanashree Svasti has an excellent
                combination of comfort and convenience to suit every requirement
                as well as need.{" "}
              </Text>
            </Col>
            {/* <Col>
                    <Link style={{ fontWeight: 500 }}>View All ({facilities.length})</Link>
                  </Col> */}
          </Row>
          <Row gutter={[16, 16]} style={{ margin: 24 }}>
            {facilities.map((facility, index) => (
              <Col xs={12} sm={8} md={6} lg={6} key={index}>
                <img
                  src={facility.icon}
                  alt={facility.name}
                  style={{ width: 80, height: 80 }}
                />
              </Col>
            ))}
          </Row>
        </Row>
      </div>
      {/* builder info */}

      <div id="builder">
        <Card style={{ padding: 24, borderRadius: 12 }}>
          <Row align="middle" justify="space-between">
            {/* Left: Logo and title */}
            <Col xs={24} sm={16}>
              <Row align="middle" gutter={16}>
                <Col>
                  <img
                    // src={bedekarLogo}
                    alt="Bedekar Logo"
                    style={{ height: 60, width: "auto", borderRadius: 8 }}
                  />
                </Col>
                <Col>
                  <Title level={4} style={{ margin: 0 }}>
                    BEDEKAR LIFESPACES LLP
                  </Title>
                </Col>
              </Row>

              {/* Paragraph with toggle */}
              <Paragraph style={{ marginTop: 16 }}>
                {expanded ? fullText : `${fullText.slice(0, 120)}... `}
                <Text
                  type="secondary"
                  onClick={toggleExpand}
                  style={{ cursor: "pointer", marginLeft: 8 }}
                >
                  {expanded ? (
                    <>
                      Less <UpOutlined />
                    </>
                  ) : (
                    <>
                      More <DownOutlined />
                    </>
                  )}
                </Text>
              </Paragraph>
            </Col>

            {/* Right: Contact button */}
            <Col xs={24} sm={8} style={{ textAlign: "right" }}>
              <Button type="primary" icon={<PhoneOutlined />} size="large">
                Contact Builder
              </Button>
            </Col>
          </Row>
        </Card>

        <div>
          <Title level={4}>Projects by BEDEKAR LIFESPACES LLP</Title>
          <Tabs defaultActiveKey="1">
            <TabPane tab="Ongoing" key="1">
              <Card
                hoverable
                style={{ width: 300, borderRadius: 10 }}
                cover={
                  <div style={{ position: "relative" }}>
                    <img
                      alt="project"
                      src={img}
                      style={{
                        height: 200,
                        objectFit: "cover",
                        borderRadius: "10px 10px 0 0",
                      }}
                    />
                    <Tag
                      color="cyan"
                      style={{ position: "absolute", top: 8, left: 8 }}
                    >
                      RERA
                    </Tag>
                    <HeartOutlined
                      style={{
                        position: "absolute",
                        top: 8,
                        right: 8,
                        fontSize: 20,
                        color: "#fff",
                      }}
                    />
                    <div
                      style={{
                        position: "absolute",
                        bottom: 0,
                        left: 0,
                        width: "100%",
                        background: "rgba(0,0,0,0.6)",
                        color: "#fff",
                        padding: "4px 8px",
                        fontSize: 12,
                        borderRadius: "0 0 10px 10px",
                      }}
                    >
                      Possession from Dec 2025
                    </div>
                  </div>
                }
              >
                <Title level={5} style={{ marginBottom: 4 }}>
                  Bedekar Beezhive
                </Title>
                <Text
                  type="secondary"
                  style={{ display: "block", marginBottom: 4 }}
                >
                  Bare shell Office Space | Shop in Shahupuri, Kolhapur
                </Text>
                <Text strong style={{ color: "#0057ff" }}>
                  Price on Request
                </Text>
              </Card>
            </TabPane>

            <TabPane tab="Upcoming" key="2">
              <Text type="secondary">No upcoming projects at this time.</Text>
            </TabPane>
          </Tabs>
        </div>
      </div>

      <div id="faqs">
        <FAQSection />
      </div>

      <div id="articles">
        <ArticalSection />
      </div>
    </>
  );
};

export default FloorPlansSection;
