 import React, { useState } from 'react';
import { Collapse, Typography } from 'antd';
import { DownOutlined, UpOutlined } from '@ant-design/icons';
 
const { Panel } = Collapse;
const { Text, Link,Title } = Typography;

const faqData = [
  {
    question: 'What are the security features of Bedekar Dhanashree Svasti?',
    answer: 'Bedekar Dhanashree Svasti offers 24x7 Security to ensure all the residents feel safe and secure.',
  },
  {
    question: 'Who is the top builder dealing in this Bedekar Dhanashree Svasti?',
    answer: 'BEDEKAR LIFESPACES LLP is the top builder dealing in this project.',
  },
  {
    question: 'Are there any housing societies in Karvir, Kolhapur?',
    answer:
      'Around 7 projects are under-construction here. There are 18 newly launched projects in Karvir, Kolhapur.',
  },
  {
    question: "What is Bedekar Dhanashree Svasti's location?",
    answer: (
      <>
        Bedekar Dhanashree Svasti is in Karvir, Kolhapur.{' '}
        <Link href="#">Click to view project details</Link>
      </>
    ),
  },
  {
    question: 'When will the possession start in Bedekar Dhanashree Svasti?',
    answer: (
      <>
        The possession status of Bedekar Dhanashree Svasti is New Launch.{' '}
        <Link href="#">Click to view project details</Link>
      </>
    ),
  },
  {
    question: 'Who is the builder of the project?',
    answer: 'Bedekar Lifespaces LLP is the builder of the project.',
  },
  {
    question: 'How many units are available in Bedekar Dhanashree Svasti?',
    answer: 'The project has a total of 16 units.',
  },
  {
    question: 'What are the key amenities available in Bedekar Dhanashree Svasti?',
    answer: (
      <>
        The key amenities of Bedekar Dhanashree Svasti are Gymnasium, Sit Out Area, Car Parking, Gated Community, Paved Compound and CCTV Camera Security.{' '}
        <Link href="#">Click to view more amenities</Link>
      </>
    ),
  },
  {
    question: 'What kinds of BHKs are offered in this society?',
    answer: 'Bedekar Dhanashree Svasti offers 2 BHK, 3 BHK, 4 BHK Apartment for sale.',
  },
];

const FAQSection = () => {
  const [showAll, setShowAll] = useState(false);

  const displayedFAQs = showAll ? faqData : faqData.slice(0, 5);

  return (
    <div style={{ padding: '24px', backgroundColor: '#fff', borderRadius: 8 }}>
        <Title leval={4}> Frequently Asked Questions</Title>
      <Collapse
        accordion={false}
        expandIconPosition="left"
        bordered={false}
        style={{ backgroundColor: 'transparent' }}
      >
        {displayedFAQs.map((faq, index) => (
          <Panel
            key={index}
            header={
              <div style={{ display: 'flex', gap: 16, alignItems: 'flex-start' }}>
                <div
                  style={{
                    minWidth: 32,
                    height: 32,
                    backgroundColor: '#f0f2f5',
                    borderRadius: '50%',
                    textAlign: 'center',
                    lineHeight: '32px',
                    fontWeight: 'bold',
                    color: '#3f3f3f',
                  }}
                >
                  Q
                </div>
                <Text strong>{faq.question}</Text>
              </div>
            }
          >
            <Text style={{ marginLeft: 48, display: 'block' }}>{faq.answer}</Text>
          </Panel>
        ))}
      </Collapse>

      <div style={{ marginTop: 16, textAlign: 'left', marginLeft: 48 }}>
        <Text
          onClick={() => setShowAll(!showAll)}
          style={{ color: '#1890ff', cursor: 'pointer', fontWeight: 500 }}
        >
          {showAll ? (
            <>
              View Less <UpOutlined />
            </>
          ) : (
            <>
              View More <DownOutlined />
            </>
          )}
        </Text>
      </div>
    </div>
  );
};

export default FAQSection;
