import React, { useState } from "react";

function Amenities() {
  const [showAll, setShowAll] = useState(false);

  const amenitiesData = [
    { title: "Children's Play Area", icon: "🎮" },
    { title: "Waiting Lounge", icon: "🪑" },
    { title: "Yoga / Meditation...", icon: "🧘" },
    { title: "Reflexology Park", icon: "🌿" },
    { title: "Spa", icon: "💆" },
    { title: "Swimming Pool", icon: "🏊" },
    { title: "Fitness Center", icon: "💪" },
    { title: "Landscaping & Tree...", icon: "🌳" },
    { title: "Aerobics Room", icon: "🤸" },
    { title: "Kid's Pool", icon: "🏊" },
    { title: "Gymnasium", icon: "🏋️" },
    { title: "Cafeteria/Food Court", icon: "☕" },
    { title: "Barbeque Pit", icon: "🔥" },
    { title: "Guest Accommodation", icon: "🏠" },
    { title: "Indoor Games Room", icon: "🎯" },
    { title: "Indoor Squash Courts", icon: "🎾" },
  ];

  const displayedAmenities = showAll
    ? amenitiesData
    : amenitiesData.slice(0, 13);

  return (
    <div
      id="amenities"
      style={{
        padding: "24px",
        maxWidth: "1500px",
        margin: "4px 20px",
        fontFamily:
          "-apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Oxygen', 'Ubuntu', sans-serif",
        //   backgroundColor:"white",
        borderRadius: 20,
        marginTop: "20px",
      }}
    >
      <h2
        style={{
          fontSize: "32px",
          fontWeight: "600",
          marginBottom: "50px",
          color: "#1a1a1a",
          textAlign: "left",
          fontFamily: "Poppins",
        }}
      >
        Project Amenities
      </h2>

      <div
        style={{
          display: "grid",
          gridTemplateColumns: "repeat(auto-fit, minmax(150px, 1fr))",
          gap: "30px",
          marginBottom: "30px",
        }}
      >
        {displayedAmenities.map((item, index) => (
          <div
            key={index}
            style={{
              display: "flex",
              flexDirection: "column",
              alignItems: "center",
              textAlign: "center",
              gap: "12px",
            }}
          >
            <div
              style={{
                width: "70px",
                height: "70px",
                display: "flex",
                alignItems: "center",
                justifyContent: "center",
                fontSize: "32px",
                backgroundColor: "white",
                borderRadius: "8px",
                transition: "transform 0.2s ease",
                cursor: "pointer",
              }}
              onMouseEnter={(e) =>
                (e.currentTarget.style.transform = "scale(1.05)")
              }
              onMouseLeave={(e) =>
                (e.currentTarget.style.transform = "scale(1)")
              }
            >
              {item.icon}
            </div>
            <p
              style={{
                margin: 0,
                fontSize: "14px",
                color: "#333",
                fontWeight: "600",
                lineHeight: "1.4",
                fontFamily: "Poppins",
              }}
            >
              {item.title}
            </p>
          </div>
        ))}

        {!showAll && (
          <div
            onClick={() => setShowAll(true)}
            style={{
              display: "flex",
              flexDirection: "column",
              alignItems: "center",
              textAlign: "center",
              gap: "12px",
              cursor: "pointer",
            }}
          >
            <div
              style={{
                width: "70px",
                height: "70px",
                display: "flex",
                alignItems: "center",
                justifyContent: "center",
                fontSize: "18px",
                fontWeight: "600",
                backgroundColor: "#e8e9ff",
                color: "#5c5cff",
                borderRadius: "8px",
                transition: "all 0.2s ease",
              }}
              onMouseEnter={(e) => {
                e.currentTarget.style.backgroundColor = "#d4d5ff";
                e.currentTarget.style.transform = "scale(1.05)";
              }}
              onMouseLeave={(e) => {
                e.currentTarget.style.backgroundColor = "#e8e9ff";
                e.currentTarget.style.transform = "scale(1)";
              }}
            >
              +3
              <br />
              more
            </div>
            <p
              style={{
                margin: 0,
                fontSize: "14px",
                color: "#5c5cff",
                fontWeight: "500",
                fontFamily: "Poppins",
              }}
            >
              View More
            </p>
          </div>
        )}
      </div>
    </div>
  );
}

export default Amenities;
