import { useEffect, useState } from "react";
import axios from "axios";
import "./PropertyForm.css";
import { Form, Input, Select, Button, Upload, Checkbox, Radio } from "antd";

import { Steps, Progress } from "antd";
// import { useNavigate } from "react-router-dom";
import ArrowBackIcon from "@mui/icons-material/ArrowBack";
import SuccessPostAlt from "../Alert/Success/SuccessPostAlt";

const PropertyForm = () => {
  const [currentStep, setCurrentStep] = useState(1);
  const [location, setLocation] = useState("");
  const [locality, setLocality] = useState("");
  const [successOpen, setSuccessOpen] = useState(false);
  const [sublocality, setSublocality] = useState("");
  const [apartment, setApartment] = useState("");

  // ============= fetch Start ========
  const [form] = Form.useForm();
  const [postTypes, setPostTypes] = useState([]);
  const [listingType, setListingType] = useState();
  const [propertyCategory, setPropertyCategory] = useState();
  const [mainPropertyTypes, setMainPropertyTypes] = useState([]);
  const [propertyTypes, setPropertyTypes] = useState([]);
  const [propertyType, setPropertyType] = useState("");
  const [cities, setCities] = useState([]);
  // const [selectedCity, setSelectedCity] = useState(null);

  // ==== Step 1
  useEffect(() => {
    const fetchPostTypes = async () => {
      try {
        const response = await axios.get(
          "http://localhost:3001/post-type-masters"
        );
        setPostTypes(response.data);
      } catch (error) {
        console.error("Error fetching post types:", error);
      }
    };

    fetchPostTypes();
  }, []);

  useEffect(() => {
    const fetchMainPropertyTypes = async () => {
      try {
        const response = await axios.get(
          "http://localhost:3001/main-propertty-type-masters"
        );
        setMainPropertyTypes(response.data);
      } catch (error) {
        console.error("Error fetching property types:", error);
      }
    };

    fetchMainPropertyTypes();
  }, []);

  useEffect(() => {
    const fetchPropertyTypes = async () => {
      try {
        const response = await axios.get(
          "http://localhost:3001/property-type-masters"
        );
        setPropertyTypes(response.data);
      } catch (error) {
        console.error("Error fetching property types:", error);
      }
    };

    fetchPropertyTypes();
  }, []);

  const getPostTypeId = (name) => {
    const found = postTypes.find((p) => p.posttypeName === name);
    return found ? found.id : null;
  };

  const filteredPropertyTypes = propertyTypes.filter(
    (item) => item.fk_posttype_id === getPostTypeId(listingType)
  );

  // ======== Step 2
  // Fetch city list from API (city_master)
  useEffect(() => {
    const fetchCities = async () => {
      try {
        const response = await axios.get("http://localhost:3001/city-masters");
        setCities(response.data);
      } catch (error) {
        console.error("Failed to fetch cities:", error);
      }
    };

    fetchCities();
  }, []);

  // ============= Fetch END =========

  // ======
  const handleContinue = async () => {
    try {
      const values = await form.validateFields(); // will validate listingType and propertyCategory
      if (!propertyType) {
        throw new Error("Please select a property type");
      }

      // Now continue to next step
      console.log("Form Data:", {
        ...values,
        propertyType,
      });
      // Move to next step here
      setCurrentStep(currentStep + 1);
    } catch (err) {
      if (
        err instanceof Error &&
        err.message === "Please select a property type"
      ) {
        // Show custom error UI (optional)
      } else {
        console.log("Validation Error:", err);
      }
    }
  };

  // ========
  const percentComplete = Math.round(((currentStep - 1) / 5) * 100);

  const handleStepChange = (value) => {
    setCurrentStep(value + 1);
  };

  // const navigate = useNavigate();

  // const handleContinue = () => {
  //   if (currentStep === 1 && propertyType) {
  //     setCurrentStep(2);
  //   } else if (currentStep === 2 && locality) {
  //     setCurrentStep(3);
  //   } else if (currentStep === 3 && locality) {
  //     setCurrentStep(4);
  //   } else if (currentStep === 4 && locality) {
  //     setCurrentStep(5);
  //   } else if (currentStep === 5 && locality) {
  //     setCurrentStep(5);
  //     setSuccessOpen(true);
  //     setTimeout(() => {
  //       navigate("/"); // Adjust route to actual Demo.jsx path
  //     }, 3000);
  //   } else {
  //     //alert("Proceeding to next step...");
  //   }
  // };

  const handleBack = () => {
    if (currentStep > 1) setCurrentStep(currentStep - 1);
  };

  const localitiesByCity = {
    "Pune West": ["Baner", "Balewadi", "Hinjewadi", "Pan Card Club Road"],
    Mumbai: ["Andheri East", "Bandra", "Borivali", "Dadar"],
    Delhi: ["Dwarka", "Rohini", "Lajpat Nagar", "Saket"],
  };

  const normalizedLocation = location.trim().toLowerCase();
  const matchedCity = Object.keys(localitiesByCity).find(
    (city) => city.toLowerCase() === normalizedLocation
  );

  const matchedLocalities = matchedCity ? localitiesByCity[matchedCity] : [];

  return (
    <div
      className="property-form-wrapper"
      style={{ display: "flex", flexWrap: "wrap", minHeight: "100vh" }}
    >
      {/* Left Sidebar */}
      <div
        className="left-sidebar"
        style={{
          flex: "0 0 300px",
          padding: "20px",
          borderRight: "1px solid #ddd",
          backgroundColor: "white",
          borderRadius: 8,
        }}
      >
        <div
          className="form-header"
          style={{ fontSize: "24px", fontWeight: "bold", marginBottom: "20px" }}
        >
          Lello Properties
        </div>

        <Steps
          direction="vertical"
          current={currentStep - 1}
          onChange={handleStepChange}
          items={[
            {
              title: "Basic Details",
              description:
                currentStep >= 1
                  ? `${propertyType || "Property Type"} for ${listingType}`
                  : "",
            },
            {
              title: "Location Details",
              // description: location || '',
            },
            {
              title: "Property Profile",
            },
            {
              title: "Photos, Videos & Voice-over",
            },
            {
              title: "Pricing and Other",
            },
          ]}
        />

        <div
          style={{
            marginTop: "40px",
            padding: "5px",
            border: "1px solid #ddd",
            borderRadius: "10px",
            textAlign: "center",
            background: "rgb(245, 245, 245)",
          }}
        >
          <p style={{ margin: "0", fontWeight: "bold", marginBottom: "10px" }}>
            Property Score
          </p>
          <Progress
            type="circle"
            percent={percentComplete}
            strokeColor="#52c41a"
            width={60}
            format={(percent) => `${percent}%`}
          />
          <p style={{ fontSize: "12px", color: "gray", marginTop: "10px" }}>
            Better your property score, greater your visibility
          </p>
        </div>
      </div>

      {/* post-right */}
      <div
        className="post-right"
        style={{ flex: "1 1 700px", padding: "30px", maxWidth: "650px" }}
      >
        {/* Step 1 */}
        {currentStep === 1 && (
          <>
            <h2>Start posting your property, it's free</h2>

            <Form layout="vertical" form={form} onFinish={handleContinue}>
              {/* Listing Type */}
              <Form.Item
                label="You're looking to ..."
                name="listingType"
                rules={[
                  { required: true, message: "Please select listing type" },
                ]}
              >
                <Radio.Group
                  value={listingType}
                  onChange={(e) => {
                    setListingType(e.target.value);
                    form.setFieldsValue({ listingType: e.target.value });
                  }}
                  buttonStyle="solid"
                >
                  {postTypes.map((type) => (
                    <Radio.Button key={type.id} value={type.posttypeName}>
                      {type.posttypeName}
                    </Radio.Button>
                  ))}
                </Radio.Group>
              </Form.Item>

              {/* Property Category */}
              <Form.Item
                label="And it's a ..."
                name="propertyCategory"
                rules={[
                  {
                    required: true,
                    message: "Please select property category",
                  },
                ]}
              >
                <Radio.Group
                  value={propertyCategory}
                  onChange={(e) => {
                    setPropertyCategory(e.target.value);
                    form.setFieldsValue({ propertyCategory: e.target.value });
                  }}
                >
                  {mainPropertyTypes.map((type) => (
                    <Radio key={type.id} value={type.mainprpoertyName}>
                      {type.mainprpoertyName}
                    </Radio>
                  ))}
                </Radio.Group>
              </Form.Item>

              {/* Property Type */}
              <Form.Item label="Select property type" required>
                <div
                  className="property-type-buttons"
                  style={{ display: "flex", flexWrap: "wrap", gap: "10px" }}
                >
                  {filteredPropertyTypes.map((option, index) => (
                    <Button
                      key={index}
                      type={
                        propertyType === option.propertytypeName
                          ? "primary"
                          : "default"
                      }
                      onClick={() => setPropertyType(option.propertytypeName)}
                    >
                      {option.propertytypeName}
                    </Button>
                  ))}
                </div>
                {!propertyType && (
                  <div style={{ color: "red", marginTop: "8px" }}>
                    Please select a property type
                  </div>
                )}
              </Form.Item>

              <Form.Item>
                <div className="form-actions" style={{ marginTop: "20px" }}>
                  <Button
                    type="primary"
                    htmlType="submit"
                    className="continue-btn"
                  >
                    Continue
                  </Button>
                </div>
              </Form.Item>
            </Form>
          </>
        )}

        {/* Step 2 */}
        {currentStep === 2 && (
          <>
            <button
              className="back-btn"
              onClick={handleBack}
              style={{ backgroundColor: "white", marginBottom: "20px" }}
            >
              <ArrowBackIcon />
            </button>

            <h2>Where is your property located?</h2>
            <p className="subtext">
              An accurate location helps you connect with the right buyers.
            </p>

            <Form
              form={form} // ADD THIS if not added
              layout="vertical"
              style={{ marginTop: "20px" }}
              onFinish={handleContinue}
            >
              {/* City */}
              <Form.Item
                label="City"
                name="city"
                rules={[{ required: true, message: "Please select your city" }]}
              >
                <Select
                  showSearch
                  placeholder="Select your city"
                  value={location}
                  onChange={(value) => {
                    setLocation(value);
                    form.setFieldsValue({ city: value }); // sync with form
                  }}
                  filterOption={(input, option) =>
                    option.children.toLowerCase().includes(input.toLowerCase())
                  }
                  suffixIcon={
                    <span role="img" aria-label="location">
                      📍
                    </span>
                  }
                >
                  {cities.map((city) => (
                    <Option key={city.id} value={city.cityName}>
                      {city.cityName}
                    </Option>
                  ))}
                </Select>
              </Form.Item>

              {cities && (
                <>
                  {/* Locality */}
                  <Form.Item
                    label="Locality"
                    name="locality"
                    rules={[
                      {
                        required: true,
                        message: "Please select your locality",
                      },
                    ]}
                  >
                    <Input
                      list="locality-options"
                      placeholder="Locality/Apartment"
                      value={locality}
                      onChange={(e) => {
                        const value = e.target.value;
                        setLocality(value);
                        form.setFieldsValue({ locality: value });
                      }}
                    />
                    <datalist id="locality-options">
                      {matchedLocalities.map((loc, index) => (
                        <option key={index} value={loc} />
                      ))}
                    </datalist>
                  </Form.Item>

                  {/* Sublocality */}
                  <Form.Item label="Sub Locality (optional)" name="sublocality">
                    <Input
                      placeholder="Sub Locality"
                      value={sublocality}
                      onChange={(e) => {
                        const value = e.target.value;
                        setSublocality(value);
                        form.setFieldsValue({ sublocality: value });
                      }}
                    />
                  </Form.Item>

                  {/* Apartment */}
                  <Form.Item label="Apartment/Society" name="apartment">
                    <Input
                      placeholder="Apartment or Society"
                      value={apartment}
                      onChange={(e) => {
                        const value = e.target.value;
                        setApartment(value);
                        form.setFieldsValue({ apartment: value });
                      }}
                    />
                  </Form.Item>
                </>
              )}

              {/* Button */}
              <Form.Item>
                <div className="form-actions" style={{ marginTop: "20px" }}>
                  <button className="continue-btn" htmlType="submit">
                    Continue
                  </button>
                </div>
              </Form.Item>
            </Form>
          </>
        )}

        {/* Step 3 */}
        {currentStep === 3 && (
          <>
            <button
              className="back-btn"
              onClick={handleBack}
              style={{ backgroundColor: "white", marginBottom: "20px" }}
            >
              <ArrowBackIcon />
            </button>

            <h2>Property Profile</h2>
            <p className="subtext">Provide more details about your property.</p>

            <Form layout="vertical" style={{ marginTop: "20px" }}>
              <Form.Item
                label="Built-up Area (sq.ft)"
                name="builtupArea"
                rules={[
                  { required: true, message: "Please enter the built-up area" },
                ]}
              >
                <Input type="number" placeholder="Enter built-up area" />
              </Form.Item>

              <Form.Item
                label="No. of Bedrooms"
                name="bedrooms"
                rules={[
                  {
                    required: true,
                    message: "Please select number of bedrooms",
                  },
                ]}
              >
                <Select placeholder="Select number of bedrooms">
                  <Select.Option value="1 BHK">1 BHK</Select.Option>
                  <Select.Option value="2 BHK">2 BHK</Select.Option>
                  <Select.Option value="3 BHK">3 BHK</Select.Option>
                  <Select.Option value="4+ BHK">4+ BHK</Select.Option>
                </Select>
              </Form.Item>

              <Form.Item>
                <div className="form-actions" style={{ marginTop: "20px" }}>
                  <button className="continue-btn" onClick={handleContinue}>
                    Continue
                  </button>
                </div>
              </Form.Item>
            </Form>
          </>
        )}

        {/* Step 4 */}
        {currentStep === 4 && (
          <>
            <button
              className="back-btn"
              onClick={handleBack}
              style={{ backgroundColor: "white", marginBottom: "20px" }}
            >
              <ArrowBackIcon />
            </button>

            <h2>Photos, Videos & Voice-over</h2>
            <p className="subtext">
              Upload media to make your listing more attractive.
            </p>

            <Form layout="vertical" style={{ marginTop: "20px" }}>
              {/* Upload Images */}
              <Form.Item label="Upload Images" name="images">
                <Upload
                  listType="picture-card"
                  multiple
                  beforeUpload={() => false} // prevent auto upload
                >
                  <div>+ Upload</div>
                </Upload>
              </Form.Item>

              {/* Upload Video */}
              <Form.Item label="Upload Video" name="video">
                <Upload accept="video/*" beforeUpload={() => false}>
                  <Button>Click to Upload Video</Button>
                </Upload>
              </Form.Item>

              {/* Upload Voice-over */}
              <Form.Item label="Voice-over Description (optional)" name="audio">
                <Upload accept="audio/*" beforeUpload={() => false}>
                  <Button>Click to Upload Audio</Button>
                </Upload>
              </Form.Item>

              <Form.Item>
                <div className="form-actions" style={{ marginTop: "20px" }}>
                  <button className="continue-btn" onClick={handleContinue}>
                    Continue
                  </button>
                </div>
              </Form.Item>
            </Form>
          </>
        )}

        {/* Step 5 */}
        {currentStep === 5 && (
          <>
            <button
              className="back-btn"
              onClick={handleBack}
              style={{ backgroundColor: "white", marginBottom: "20px" }}
            >
              <ArrowBackIcon />
            </button>

            <h2>Pricing and Other</h2>
            <p className="subtext">
              Select the Pricing available in the property.
            </p>

            <Form layout="vertical" style={{ marginTop: "20px" }}>
              {/* Pricing Amount Field */}
              <Form.Item
                label="Pricing"
                name="pricingAmount"
                rules={[{ required: true, message: "Please enter pricing" }]}
              >
                <Input
                  type="number"
                  placeholder="Enter price (e.g. ₹5000)"
                  prefix="₹"
                />
              </Form.Item>

              {/* Amenities Checkboxes */}
              <Form.Item label="Select Amenities" name="amenities">
                <Checkbox.Group
                  style={{ display: "flex", flexWrap: "wrap", gap: "16px" }}
                >
                  {[
                    "Lift",
                    "Power Backup",
                    "Parking",
                    "Security",
                    "Swimming Pool",
                    "Gym",
                  ].map((amenity) => (
                    <Checkbox key={amenity} value={amenity}>
                      {amenity}
                    </Checkbox>
                  ))}
                </Checkbox.Group>
              </Form.Item>

              {/* Continue Button */}
              <Form.Item>
                <div className="form-actions" style={{ marginTop: "20px" }}>
                  <button className="continue-btn" onClick={handleContinue}>
                    Continue
                  </button>
                </div>
              </Form.Item>
            </Form>
          </>
        )}

        <div className="help-section" style={{ marginTop: "40px" }}>
          <p>Need help?</p>
          <p>
            You can email us at <strong>service@lello.com</strong> or call us at{" "}
            <strong>1800 41 99099</strong> (NO Toll-Free).
          </p>
        </div>
      </div>

      <SuccessPostAlt
        open={successOpen}
        onClose={() => setSuccessOpen(false)}
      />
    </div>
  );
};

export default PropertyForm;
