
import React, { useState } from 'react';
import './PostProperty.css';
import illustration from '../../assets/animated.gif';
import MarkunreadIcon from '@mui/icons-material/Markunread';
import EditIcon from '@mui/icons-material/Edit';
import Visibility from '@mui/icons-material/Visibility';
import VisibilityOff from '@mui/icons-material/VisibilityOff';



const PostProperty = () => {
    const [listingType, setListingType] = useState('Sell');
    const [propertyType, setPropertyType] = useState('Residential');
    const [showModal, setShowModal] = useState(false);
    const [showPhoneModal, setShowPhoneModal] = useState(true);
    const [showEmailModal, setShowEmailModal] = useState(false);
    const [showEmailStep2Modal, setShowEmailStep2Modal] = useState(false);
    const [showPassword, setShowPassword] = useState(false);



    const [email, setEmail] = useState('');
    const [password, setPassword] = useState('');
    const [subscribeWhatsApp, setSubscribeWhatsApp] = useState(false);
    const [showError, setShowError] = useState(false);
    const [isPhoneFocused, setIsPhoneFocused] = useState(false);

    const propertyOptions = {
        Sell: [
            "Flat/Apartment", "Independent House / Villa", "Independent / Builder Floor",
            "Plot / Land", "1 RK/Studio Apartment", "Serviced Apartment", "Farmhouse", "Other"
        ],
        "Rent / Lease": [
            "Flat/Apartment", "Independent House / Villa", "Independent / Builder Floor",
            "1 RK/Studio Apartment", "Serviced Apartment", "Farmhouse", "Other"
        ],
        PG: [
            "Flat/Apartment", "Independent House / Villa", "Independent / Builder Floor",
            "1 RK/Studio Apartment", "Serviced Apartment"
        ]
    };

    const handlePhoneClick = () => {
        setShowModal(true);
        setShowPhoneModal(true);
        setShowEmailModal(false);
        setShowEmailStep2Modal(false);
    };

    const handleEmailClick = () => {
        setShowPhoneModal(false);
        setShowEmailModal(true);
        setShowEmailStep2Modal(false);
    };

    const handleEmailContinue = () => {
        if (email) {
            setShowEmailModal(false);
            setShowEmailStep2Modal(true);
        }
    };

    const handleStartClick = () => {
        setShowError(true);
    };

    return (
        <div className="post-property-container">
            <div className="post-left">
                <h1>
                    Sell or Rent Property <br />
                    <span className="highlight">online faster</span> with 99acres.com
                </h1>
                <ul className="benefits-list">
                    <li>Advertise for FREE</li>
                    <li>Get unlimited enquiries</li>
                    <li>Get shortlisted buyers and tenants *</li>
                    <li>Assistance in co-ordinating site visits *</li>
                </ul>
                <img src={illustration} alt="animated" className="illustration" />
            </div>

            <div className="post-right">
                <h2>Start posting your property, it's free</h2>

                <p className="section-label">You're looking to ...</p>
                <div className="button-group">
                    {['Sell', 'Rent / Lease', 'PG'].map((type) => (
                        <button
                            key={type}
                            className={listingType === type ? 'active' : ''}
                            onClick={() => setListingType(type)}
                        >
                            {type}
                        </button>
                    ))}
                </div>

                <p className="section-labels">And it's a ...</p>
                <div className="radio-group">
                    <label className="radio-label">
                        <input
                            type="radio"
                            name="propertyType"
                            checked={propertyType === 'Residential'}
                            onChange={() => setPropertyType('Residential')}
                        />
                        <span className="radio-custom"></span> Residential
                    </label>
                    <label className="radio-label">
                        <input
                            type="radio"
                            name="propertyType"
                            checked={propertyType === 'Commercial'}
                            onChange={() => setPropertyType('Commercial')}
                        />
                        <span className="radio-custom"></span> Commercial
                    </label>
                </div>

                <div className="property-buttons">
                    {propertyOptions[listingType].map((option, index) => (
                        <button key={index}>{option}</button>
                    ))}
                </div><br />

                <div className="phone-input-section">
                    <h5 className="phone-text">Your contact details for the tenants to reach you</h5>

                    <input
                        type="text"
                        placeholder="Phone Number"
                        className="simple-phone-input"
                        style={{ backgroundColor: 'white' }}
                        onClick={handlePhoneClick}
                        readOnly
                    />
                </div>

                <p className="login-text">
                    Are you a registered user? <a href="#">Login</a>
                </p>

                <button className="start-btn" onClick={handleStartClick}>Start now</button>
            </div>

            {/* Phone Modal */}
            {showModal && showPhoneModal && (
                <div className="modal-overlay">
                    <div className="modal-box">
                        <h3>Login / Register</h3>
                        <p>Please enter your Phone Number</p>

                        <div style={{
                            display: 'flex',
                            border: '1px solid #ccc',
                            borderRadius: '4px',
                            overflow: 'hidden',
                            width: '100%'
                        }}>
                            <select style={{
                                padding: '10px',
                                border: 'none',
                                backgroundColor: 'white',
                                color: '#000',
                                borderRight: '1px solid #ccc'
                            }}>
                                <option value="+91">+91</option>
                                <option value="+1">+1</option>
                                <option value="+44">+44</option>
                            </select>
                            <input
                                type="text"
                                placeholder="Phone Number"
                                style={{
                                    padding: '10px',
                                    border: 'none',
                                    outline: 'none',
                                    flex: 1,
                                    backgroundColor: 'white',
                                    color: 'black'
                                }}
                            />
                        </div><br />

                        <button className="continue-btn">Continue</button>
                        <div className="or-divider">Or</div>

                        <button
                            className="email-btn"
                            onClick={handleEmailClick}
                            style={{
                                display: 'flex',
                                alignItems: 'center',
                                justifyContent: 'center',
                                gap: '10px',
                                padding: '12px 20px',
                                width: '100%',
                                border: '1px solid #ddd',
                                backgroundColor: '#fff',
                                color: '#555',
                                borderRadius: '4px',
                                cursor: 'pointer',
                            }}
                        >
                            <MarkunreadIcon style={{ fontSize: '18px' }} />
                            <span>Continue with Email/Username</span>
                        </button>

                        <p className="terms-texts">
                            By clicking you agree to <a href="#">Terms and Conditions</a>
                        </p>
                        <button className="close-modal" onClick={() => setShowModal(false)}>×</button>
                    </div>
                </div>
            )}

            {/* Email Modal - Step 1 */}
            {showModal && showEmailModal && (
                <div className="modal-overlay">
                    <div className="modal-box">
                        <button className="close-modal" onClick={() => setShowModal(false)}>×</button>
                        <h3>Login / Register</h3>
                        <p>Please enter your Email ID/Username</p>

                        <div className="modal-email-input-group">
                            <input
                                style={{
                                    backgroundColor: 'white',
                                    height: '40px',
                                    width: '100%',
                                    padding: '8px 12px',
                                    border: '1px solid #ccc',
                                    borderRadius: '4px',
                                    fontSize: '14px',
                                    color: 'black'
                                }}
                                type="email"
                                placeholder="Email ID/Username"
                                value={email}
                                onChange={(e) => setEmail(e.target.value)}
                                className="modal-email-input"
                            />

                        </div><br />

                        <button className="continue-btn" onClick={handleEmailContinue}>Continue</button>
                    </div>
                </div>
            )}


            {/* Email Step 2 Modal - Email + Password + WhatsApp */}
            {showModal && showEmailStep2Modal && (
                <div className="modal-overlay">
                    <div className="modal-box">
                        <button className="close-modal" onClick={() => {
                            setShowModal(false);
                            setShowEmailStep2Modal(false);
                        }}>×</button>

                        <h3>Enter Password</h3>


                        <div style={{ position: 'relative', marginBottom: '10px' }}>
                            <input
                                type="email"
                                value={email}
                                readOnly
                                style={{
                                    backgroundColor: '#f5f5f5',
                                    height: '40px',
                                    width: '100%',
                                    padding: '8px 35px 8px 12px',
                                    border: '1px solid #ccc',
                                    borderRadius: '4px',
                                    fontSize: '14px',
                                    color: '#000'
                                }}
                            />
                            <span
                                style={{
                                    position: 'absolute',
                                    right: '10px',
                                    top: '50%',
                                    transform: 'translateY(-50%)',
                                    cursor: 'pointer',
                                    fontSize: '14px',
                                    color: '#007bff'
                                }}
                                onClick={() => {
                                    setShowEmailStep2Modal(false);
                                    setShowEmailModal(true);
                                }}
                            >
                                <EditIcon
                                    onClick={() => {
                                        setShowEmailStep2Modal(false);
                                        setShowEmailModal(true);
                                    }}
                                    style={{
                                        position: 'absolute',
                                        right: '10px',
                                        top: '50%',
                                        transform: 'translateY(-50%)',
                                        cursor: 'pointer',
                                        fontSize: '18px',
                                        color: '#007bff'
                                    }}
                                />

                            </span>
                        </div>



                        {/* Password Field with Show Toggle */}
                        <div style={{ position: 'relative', marginBottom: '10px' }}>
                            <input
                                type={showPassword ? 'text' : 'password'}
                                value={password}
                                onChange={(e) => setPassword(e.target.value)}
                                placeholder="Password"
                                style={{
                                    backgroundColor: 'white',
                                    height: '40px',
                                    width: '100%',
                                    padding: '8px 35px 8px 12px',
                                    border: '1px solid #ccc',
                                    borderRadius: '4px',
                                    fontSize: '14px',
                                    color: '#000',
                                }}
                            />
                            <span
                                onClick={() => setShowPassword(!showPassword)}
                                style={{
                                    position: 'absolute',
                                    right: '10px',
                                    top: '50%',
                                    transform: 'translateY(-50%)',
                                    cursor: 'pointer',
                                    fontSize: '13px',
                                    color: '#007bff',
                                }}
                            >
                                {/* {showPassword ? 'Hide' : 'Show'} */}
                                {showPassword ? <VisibilityOff /> : <Visibility />}
                            </span>
                        </div>

                        {/* Forgot Password */}
                        <div style={{ textAlign: 'right', marginBottom: '12px' }}>
                            <a
                                href="#"
                                style={{
                                    fontSize: '13px',
                                    color: '#007bff',
                                    textDecoration: 'none',
                                }}
                            >
                                Forgot Password?
                            </a>
                        </div>





                        <label
                            className="custom-checkbox"
                            style={{ color: '#007bff' }}
                        >
                            <input
                                type="checkbox"
                                checked={subscribeWhatsApp}
                                onChange={() => setSubscribeWhatsApp(!subscribeWhatsApp)}
                            />
                            <span className="checkmark"></span>
                            Get updates on WhatsApp
                        </label><br />

                        <button className="continue-btn">Login</button>
                    </div>
                </div>
            )}

        </div>
    );
};

export default PostProperty;



