import React, { useEffect, useState } from 'react';
import './PartnerSection.css';
import { Swiper, SwiperSlide } from 'swiper/react';
import 'swiper/css';
import 'swiper/css/autoplay';
import 'swiper/css/navigation';
import { Autoplay } from 'swiper/modules';
import axios from 'axios';
import { URL } from '../../config';

// Local fallback images
import partner1 from "../../assets/partner1.avif";
import partner2 from "../../assets/partner2.avif";
import partner3 from "../../assets/partner3.avif";
import partner4 from "../../assets/partner4.avif";
import partner5 from "../../assets/partner5.avif";
import partner6 from "../../assets/partner6.avif";
import partner7 from "../../assets/eco.avif";

const fallbackImages = [partner1, partner2, partner3, partner4, partner5, partner6, partner7];

const PartnerSection = () => {
  const [partners, setPartners] = useState([]);

  useEffect(() => {
    axios
      .get(`${URL}/our-partner-masters`)
      .then((res) => setPartners(res.data))
      .catch((err) => console.error("Error fetching partners:", err));
  }, []);

  return (
    <div className="ps-container">
      <div className="ps-header">
        <h1>Our Partners</h1>
        <h2>Instant Updates</h2>
      </div>

      {partners.length >= 5 ? (
        <Swiper
          modules={[Autoplay]}
          autoplay={{ delay: 2500, disableOnInteraction: false }}
          loop={true}
          spaceBetween={30}
          slidesPerView={5}
          breakpoints={{
            320: { slidesPerView: 1, spaceBetween: 10 },
            480: { slidesPerView: 2, spaceBetween: 15 },
            640: { slidesPerView: 2, spaceBetween: 20 },
            768: { slidesPerView: 3, spaceBetween: 25 },
            1024: { slidesPerView: 5, spaceBetween: 30 },
          }}
        >
          {partners.map((partner, index) => (
            <SwiperSlide key={index}>
              <div className={`ps-card ${index % 2 === 0 ? "ps-faint" : ""}`}>
                <img
                  src={partner.partnerLogo || fallbackImages[index % fallbackImages.length]}
                  alt={partner.partnerName || "Partner"}
                  className="ps-img"
                  onError={(e) => {
                    e.target.onerror = null;
                    e.target.src = fallbackImages[index % fallbackImages.length];
                  }}
                />
                <h3>{partner.partnerName || "Unknown Partner"}</h3>
              </div>
            </SwiperSlide>
          ))}
        </Swiper>
      ) : (
        <p style={{ textAlign: "center", marginTop: "20px" }}>
          Not enough partners to display slider.
        </p>
      )}
    </div>
  );
};

export default PartnerSection;
