import React, { useState } from "react";
import {
  Layout,
  Menu,
  Drawer,
  Button,
  Modal,
  Input,
  Select,
  Typography,
  Divider,
} from "antd";
import {
  MenuOutlined,
  UserOutlined,
  CloseOutlined,
  ArrowLeftOutlined,
  MailOutlined,
} from "@ant-design/icons";
import "./HeaderNavbar.css";
// import Logo from "../../../assets/Logo/Logo-lello2.jfif"; // Local image for logo

const { Header } = Layout;
const { Option } = Select;
const { Paragraph } = Typography;

const serviceData = {
  "For Buyers": ["Buy Flats", "Budget Homes", "New Projects"],
  "For Tenants": ["Rental Homes", "PGs", "Co-living"],
  "For Owners": ["Post Property", "Rent Management"],
  "For Dealers / Builders": ["Agent Login", "Builder Plans"],
};

const homeLoan = {
  Insights: ["Home Loan Tips", "Interest Rates", "EMI Calculator"],
  "Article and News": ["Home Loan News", "Government Policies"],
};

const aboutUs = {
  "Get Help": ["Customer Support", "FAQ", "Contact Us"],
};

const HeaderNavbar = () => {
  const [sidebarOpen, setSidebarOpen] = useState(false);
  const [subSidebarOpen, setSubSidebarOpen] = useState(false);
  const [activeSection, setActiveSection] = useState("");
  const [dataSource, setDataSource] = useState({});
  const [dropdownOpen, setDropdownOpen] = useState(false);
  const [showModal, setShowModal] = useState(false);
  const [showPhoneModal, setShowPhoneModal] = useState(true);

  const openSubSidebar = (section, source = "serviceData") => {
    setActiveSection(section);
    if (source === "serviceData") setDataSource(serviceData);
    else if (source === "homeLoan") setDataSource(homeLoan);
    else if (source === "aboutUs") setDataSource(aboutUs);
    setSubSidebarOpen(true);
  };

  const closeSubSidebar = () => {
    setSubSidebarOpen(false);
    setActiveSection("");
  };

  const handleEmailClick = () => {
    setShowPhoneModal(false);
  };

  return (
    <>
      {/* Header with Background Image */}
      <Header className="top-navbar">
        <a href="/" className="logo">
          <img src={Logo} alt="Lello Logo" />
        </a>

        <div className="nav-icons">
          <UserOutlined
            onClick={() => setDropdownOpen(!dropdownOpen)}
            className="icon border border-3 border-white rounded-circle p-2"
          />
          <MenuOutlined
            onClick={() => setSidebarOpen(true)}
            className="icon border border-3 border-white rounded p-2"
          />
        </div>
      </Header>

      {/* Main Drawer */}
      <Drawer
        title={
          <div style={{ display: "flex", justifyContent: "space-between" }}>
            <span>
              <UserOutlined />
               LOGIN / REGISTER
            </span>
            {/* <CloseOutlined onClick={() => setSidebarOpen(false)} /> */}
          </div>
        }
        placement="right"
        width={280}
        open={sidebarOpen}
        onClose={() => setSidebarOpen(false)}
      >
        <Button type="link" style={{ padding: 0, fontWeight: "bold" }}>
          Post Property <span className="free-badge">FREE</span>
        </Button>

        <Divider orientation="left">Explore our Services</Divider>
        {Object.keys(serviceData).map((item) => (
          <p
            key={item}
            className="collapsible-title"
            onClick={() => openSubSidebar(item, "serviceData")}
          >
            ▸ {item}
          </p>
        ))}

        <Divider orientation="left">Home Loans</Divider>
        {Object.keys(homeLoan).map((item) => (
          <p
            key={item}
            className="collapsible-title"
            onClick={() => openSubSidebar(item, "homeLoan")}
          >
            ▸ {item}
          </p>
        ))}

        <Divider orientation="left">About Us</Divider>
        {Object.keys(aboutUs).map((item) => (
          <p
            key={item}
            className="collapsible-title"
            onClick={() => openSubSidebar(item, "aboutUs")}
          >
            ▸ {item}
          </p>
        ))}

        <Divider />
        <Input.Search
          placeholder="Search by Property Code"
          style={{ marginBottom: 10 }}
        />
        <Paragraph>
          <strong>Toll Free Number:</strong> 1800 41 99099 <br />
          <span>
            For international numbers <a href="#">click here</a>
          </span>
        </Paragraph>
      </Drawer>

      {/* Sub Sidebar Drawer */}
      <Drawer
        title={
          <div style={{ display: "flex", alignItems: "center", gap: 10 }}>
            <ArrowLeftOutlined onClick={closeSubSidebar} />
            <span>{activeSection}</span>
          </div>
        }
        placement="left"
        width={240}
        open={subSidebarOpen}
        onClose={closeSubSidebar}
      >
        <Menu mode="vertical" selectable={false}>
          {(dataSource[activeSection] || []).map((item, index) => (
            <Menu.Item key={index}>{item}</Menu.Item>
          ))}
        </Menu>
      </Drawer>

      {/* Login Modal */}
      <Modal
        title="Login / Register"
        open={showModal && showPhoneModal}
        footer={null}
        onCancel={() => setShowModal(false)}
      >
        <p>Please enter your Phone Number</p>
        <Input.Group compact>
          <Select defaultValue="+91" style={{ width: "25%" }}>
            <Option value="+91">+91</Option>
            <Option value="+1">+1</Option>
            <Option value="+44">+44</Option>
          </Select>
          <Input style={{ width: "75%" }} placeholder="Phone Number" />
        </Input.Group>

        <Button type="primary" block style={{ marginTop: 16 }}>
          Continue
        </Button>

        <Divider>OR</Divider>

        <Button icon={<MailOutlined />} block onClick={handleEmailClick}>
          Continue with Email/Username
        </Button>

        <Paragraph style={{ marginTop: 16, fontSize: "12px" }}>
          By clicking you agree to <a href="#">Terms and Conditions</a>
        </Paragraph>
      </Modal>
    </>
  );
};

export default HeaderNavbar;
