import React from "react";
import { Stack, Typography } from "@mui/material";
import { Link as RouterLink, useLocation } from "react-router-dom";

const DesktopNav = ({ navLinks }) => {
  const location = useLocation();

  return (
    <Stack
      direction="row"
      spacing={4}
      sx={{
        display: { xs: "none", md: "flex" },
        alignItems: "center",
      }}
    >
      {navLinks.map((link) => {
        const isActive = location.pathname === link.path;

        return (
          <Typography
            key={link.path}
            component={RouterLink}
            to={link.path}
            sx={{
              textDecoration: "none",
              color: "white",
              fontSize: "1.1rem",
              fontFamily: "Poppins",
              fontWeight: isActive ? "bold" : "normal",
              borderBottom: isActive
                ? "2px solid white"
                : "2px solid transparent",
              paddingBottom: "4px",
              transition: "all 0.3s ease",
              "&:hover": {
                color: "#E0E0E0",
                borderBottom: "2px solid #E0E0E0",
              },
            }}
          >
            {link.label}
          </Typography>
        );
      })}
    </Stack>
  );
};

export default DesktopNav;
