// import React from 'react';
// import {
//   Modal,
//   Box,
//   Typography,
//   TextField,
//   Button,
//   Divider,
//   IconButton,
// } from '@mui/material';
// import CloseIcon from '@mui/icons-material/Close';
// import axios from 'axios';
// import { useNavigate } from 'react-router-dom';
// import { URL } from "../../config";
// import { useSnackbar } from 'notistack';

// const style = {
//   position: 'absolute',
//   top: '50%',
//   left: '50%',
//   transform: 'translate(-50%, -50%)',
//   width: { xs: '90%', sm: 400 },  // Responsive width
//   bgcolor: 'white',
//   borderRadius: '12px',
//   boxShadow: 24,
//   p: { xs: 2, sm: 4 },  // Responsive padding
// };

// const PhoneModal = ({ open, handleClose, regData, setRegData, onSubmit }) => {
//   const { enqueueSnackbar } = useSnackbar();
//   const navigate = useNavigate();
// const handleContinue = async () => {
//   if (!regData.contactno || !/^\d{10}$/.test(regData.contactno)) {
//     enqueueSnackbar("Please enter a valid 10-digit phone number.", { variant: "warning" });
//     return;
//   }
//   try {
//     const res = await axios.post(`${URL}/otp-verifications`, {
//       phone_number: regData.contactno,
//     });

//     console.log(res.data);

//     if (!res.data.success) {
//       // ❌ OTP request blocked (already sent within 2 min)
//       enqueueSnackbar(res.data.message, { variant: "warning" });
//       return;
//     }

//     // ✅ One single alert (append OTP only for testing)
//     let msg = res.data.message;
//     if (res.data.otp) {
//       msg += ` (OTP: ${res.data.otp})`; // remove later in production
//     }
//     enqueueSnackbar(msg, { variant: "success" });

//     // ✅ Open OTP modal
//     onSubmit();

//   } catch (error) {
//     console.error(error);
//     enqueueSnackbar("Failed to send OTP. Please try again.", { variant: "error" });
//   }
// };

//   return (
//     <Modal open={open} onClose={handleClose}>
//       <Box sx={style}>
//         <Box display="flex" justifyContent="space-between" alignItems="center">
//           <Typography variant="h6" fontWeight="bold">Login / Register</Typography>
//           <IconButton onClick={handleClose}><CloseIcon /></IconButton>
//         </Box>

//         <Typography sx={{ mt: 2, mb: 1 }}>Please enter your Phone Number</Typography>
//         <TextField
//           fullWidth
//           variant="outlined"
//           label="Phone Number"
//           InputLabelProps={{ shrink: true }}
//           style={{ width: "100%" }}
//           value={regData.contactno}   // ✅ controlled by regData
//           onChange={(e) => {
//             const value = e.target.value;
//             if (/^\d{0,10}$/.test(value)) {
//               setRegData((prev) => ({ ...prev, contactno: value }));
//             }
//           }}
//           name="phno"
//           type="tel"
//           required
//           sx={{
//             '& label': { color: '#0d47a1', fontWeight: 'bold' },
//             '& label.Mui-focused': { color: '#1976d2' },
//             '& .MuiOutlinedInput-root': {
//               '& fieldset': { borderColor: '#ccc' },
//               '&:hover fieldset': { borderColor: '#999' },
//               '&.Mui-focused fieldset': { borderColor: '#1976d2' },
//             },
//           }}
//         />

//         <Button
//           fullWidth
//           variant="contained"
//           onClick={handleContinue}
//           sx={{ mt: 4, fontWeight: 'bold', height: '45px' }}
//         >
//           Continue
//         </Button>

//         <Divider sx={{ my: 3 }} />

//         <Typography variant="caption" sx={{ mt: 2, display: 'block', textAlign: 'center' }}>
//           By clicking you agree to <a href="#" style={{ color: '#1976d2' }}>Terms and Conditions</a>
//         </Typography>
//       </Box>
//     </Modal>
//   );
// };

// export default PhoneModal;

import React, { useEffect, useRef } from "react";
import {
  Modal,
  Box,
  Typography,
  TextField,
  Button,
  Divider,
  IconButton,
} from "@mui/material";
import CloseIcon from "@mui/icons-material/Close";
import axios from "axios";
import { useNavigate } from "react-router-dom";
import { URL } from "../../config";
import { useSnackbar } from "notistack";

const style = {
  position: "absolute",
  top: "50%",
  left: "50%",
  transform: "translate(-50%, -50%)",
  width: "90%",
  maxWidth: "400px",
  bgcolor: "background.paper",
  borderRadius: 2,
  boxShadow: 24,
  p: { xs: 2, sm: 4 },
  outline: "none",
};

const PhoneModal = ({ open, handleClose, regData, setRegData, onSubmit }) => {
  const { enqueueSnackbar } = useSnackbar();
  const navigate = useNavigate();
  const inputRef = useRef(null);

  // ✅ Focus the input when modal opens
  useEffect(() => {
    if (open) {
      // Wait for modal to render fully before focusing
      setTimeout(() => {
        if (inputRef.current) {
          inputRef.current.focus();
        }
      }, 100); // small delay works reliably
    }
  }, [open]);

  const handleContinue = async () => {
    if (!regData.contactno || !/^\d{10}$/.test(regData.contactno)) {
      enqueueSnackbar("Please enter a valid 10-digit phone number.", {
        variant: "warning",
      });
      return;
    }
    try {
      const res = await axios.post(`${URL}/otp-verifications`, {
        phone_number: regData.contactno,
      });

      console.log(res.data);

      if (!res.data.success) {
        enqueueSnackbar(res.data.message, { variant: "warning" });
        return;
      }

      let msg = res.data.message;
      if (res.data.otp) {
        msg += ` (OTP: ${res.data.otp})`; // Remove in production
      }
      enqueueSnackbar(msg, { variant: "success" });

      onSubmit();
    } catch (error) {
      console.error(error);
      enqueueSnackbar("Failed to send OTP. Please try again.", {
        variant: "error",
      });
    }
  };

  return (
    <Modal
      open={open}
      onClose={(event, reason) => {
        if (reason === "backdropClick") return; // ❌ ignore backdrop clicks
        if (reason === "escapeKeyDown") return; // ❌ ignore Esc key
        handleClose(); // ✅ only runs when we explicitly trigger close
      }}
      disableEscapeKeyDown
      hideBackdrop={false}
    >
      <Box sx={style}>
        {/* Header */}
        <Box
          display="flex"
          justifyContent="space-between"
          alignItems="center"
          flexWrap="wrap"
          mb={2}
        >
          <Typography
            variant="h6"
            fontWeight="bold"
            fontSize={{ xs: "1.1rem", sm: "1.5rem" }}
          >
            Login / Register
          </Typography>
          <IconButton onClick={handleClose}>
            <CloseIcon />
          </IconButton>
        </Box>

        {/* Instructions */}
        <Typography sx={{ mb: 2, fontSize: { xs: "0.85rem", sm: "1rem" } }}>
          Please enter your Phone Number
        </Typography>

        {/* Phone Input with Autofocus */}
        <TextField
          fullWidth
          inputRef={inputRef} // ✅ Ref to focus
          autoFocus // ✅ Works with ref on mount
          variant="outlined"
          label="Phone Number"
          InputLabelProps={{ shrink: true }}
          value={regData.contactno}
          onChange={(e) => {
            const value = e.target.value;
            if (/^\d{0,10}$/.test(value)) {
              setRegData((prev) => ({ ...prev, contactno: value }));
            }
          }}
          name="phno"
          type="tel"
          required
          sx={{
            "& label": { color: "#0d47a1", fontWeight: "bold" },
            "& label.Mui-focused": { color: "#1976d2" },
            "& .MuiOutlinedInput-root": {
              "& fieldset": { borderColor: "#ccc" },
              "&:hover fieldset": { borderColor: "#999" },
              "&.Mui-focused fieldset": { borderColor: "#1976d2" },
            },
            mb: 3,
          }}
        />

        {/* Continue Button */}
        <Button
          fullWidth
          variant="contained"
          onClick={handleContinue}
          sx={{
            fontWeight: "bold",
            height: "45px",
            fontSize: { xs: "0.9rem", sm: "1rem" },
          }}
        >
          Continue
        </Button>

        <Divider sx={{ my: 3 }} />

        {/* Terms and Conditions */}
        <Typography
          variant="caption"
          sx={{
            display: "block",
            textAlign: "center",
            fontSize: { xs: "0.75rem", sm: "0.875rem" },
          }}
        >
          By clicking you agree to{" "}
          <a href="#" style={{ color: "#1976d2", textDecoration: "none" }}>
            Terms and Conditions
          </a>
        </Typography>
      </Box>
    </Modal>
  );
};

export default PhoneModal;
