// src/Components/Modal/PackageLimitModal/PackageLimitModal.jsx
import React from "react";
import { Modal, Button, Typography } from "antd";
import { CrownOutlined, CloseOutlined, ExclamationCircleOutlined } from "@ant-design/icons";
import { useNavigate } from "react-router-dom";

const { Title, Paragraph } = Typography;

const PackageLimitModal = ({ open, onClose, packageName, onUpgrade }) => {
  const navigate = useNavigate();

  const handleUpgrade = () => {
    if (onUpgrade) {
      onUpgrade();
    } else {
      navigate("/membership");
    }
    onClose();
  };

  return (
    <Modal
      open={open}
      onCancel={onClose}
      footer={null}
      closeIcon={<CloseOutlined style={{ fontSize: 18 }} />}
      width={500}
      centered
      style={{
        borderRadius: 12,
        overflow: "hidden",
      }}
      bodyStyle={{
        padding: "30px 20px",
        borderRadius: 12,
      }}
    >
      <div style={{ textAlign: "center" }}>
        <div
          style={{
            display: "flex",
            justifyContent: "center",
            marginBottom: 20,
          }}
        >
          <div
            style={{
              width: 70,
              height: 70,
              borderRadius: "50%",
              backgroundColor: "rgba(255, 77, 79, 0.1)",
              display: "flex",
              alignItems: "center",
              justifyContent: "center",
            }}
          >
            <ExclamationCircleOutlined
              style={{ fontSize: 36, color: "#ff4d4f" }}
            />
          </div>
        </div>

        <Title level={3} style={{ marginBottom: 16, color: "#333" }}>
          Package Limit Reached
        </Title>

        <Paragraph style={{ fontSize: 16, color: "#666", marginBottom: 24 }}>
          You've reached the limit of your current{" "}
          <strong>{packageName || "Lello Prime"}</strong> package. To continue
          viewing properties, please upgrade your membership.
        </Paragraph>

        <div
          style={{
            backgroundColor: "rgba(255, 77, 79, 0.1)",
            padding: "16px 20px",
            borderRadius: 8,
            marginBottom: 24,
          }}
        >
          <Title level={5} style={{ marginBottom: 8, color: "#ff4d4f" }}>
            Upgrade Benefits:
          </Title>
          <ul style={{ textAlign: "left", color: "#555", paddingLeft: 20 }}>
            <li>Unlimited property views</li>
            <li>Save unlimited properties</li>
            <li>Contact property owners directly</li>
            <li>Priority customer support</li>
          </ul>
        </div>

        <div style={{ display: "flex", gap: 12, justifyContent: "center" }}>
          <Button
            type="primary"
            size="large"
            onClick={handleUpgrade}
            style={{
              backgroundColor: "#ff4d4f",
              borderColor: "#ff4d4f",
              borderRadius: 8,
              fontWeight: 600,
              minWidth: 140,
            }}
          >
            Upgrade Now
          </Button>
          <Button
            size="large"
            onClick={onClose}
            style={{
              borderRadius: 8,
              fontWeight: 600,
              minWidth: 100,
            }}
          >
            Maybe Later
          </Button>
        </div>
      </div>
    </Modal>
  );
};

export default PackageLimitModal;