import React from "react";
import { Home } from "lucide-react";
import IMG from "../../assets/loader/loader.gif";

const Loading = ({ fullscreen = false, size = 70 }) => {
  if (fullscreen) {
    return (
      <>
        {/* Spin Animation */}
        <style>
          {`
            @keyframes spin {
              0% { transform: rotate(0deg); }
              100% { transform: rotate(360deg); }
            }
          `}
        </style>

        <div
          style={{
            position: "fixed",
            inset: 0,
            backgroundColor: "rgba(255, 255, 255, 0.6)",
            backdropFilter: "blur(2px)",
            display: "flex",
            alignItems: "center",
            justifyContent: "center",
            zIndex: 9999,
          }}
        >
          <div
            style={{
              background: "#fff",
              padding: "18px 28px",
              borderRadius: "12px",
              display: "flex",
              alignItems: "center",
              gap: "16px",
              boxShadow: "0 4px 14px rgba(0,0,0,0.15)",
              border: "1px solid #e9e9e9",
            }}
          >
            {/* Spinner Wrapper */}
            <div
              style={{
                position: "relative",
                width: size,
                height: size,
              }}
            >
              {/* Outer Rotating Ring */}
              <div
                style={{
                  position: "absolute",
                  inset: 0,
                  borderRadius: "50%",
                  border: "3px solid transparent",
                  borderTopColor: "#1976d2",
                  borderRightColor: "#1976d2",
                  animation: "spin 1s linear infinite",
                }}
              />

              {/* Inner Circle */}
              <div
                style={{
                  position: "absolute",
                  inset: "5px",
                  borderRadius: "50%",
                  background:
                    "linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%)",
                  display: "flex",
                  alignItems: "center",
                  justifyContent: "center",
                  boxShadow: "inset 0 2px 8px rgba(25, 118, 210, 0.15)",
                }}
              >
                <Home size={size * 0.45} color="#1976d2" strokeWidth={2} />
              </div>
            </div>

            {/* Text */}
            <span
              style={{
                fontSize: "18px",
                fontWeight: 500,
                color: "#444",
              }}
            >
              Loading...
            </span>
          </div>
        </div>
      </>
    );
  }

  // Normal Loader
  return (
    <div
      style={{
        display: "flex",
        alignItems: "center",
        justifyContent: "center",
        padding: "20px",
      }}
    >
      <img
        src={IMG}
        alt="Loading..."
        style={{
          width: size,
          height: size,
          objectFit: "contain",
        }}
      />
    </div>
  );
};

export default Loading;
