// // HeroSection.jsx
// import React, { useState, useEffect } from 'react';
// import axios from 'axios';
// import './Herosection.css';
// import { TypeAnimation } from 'react-type-animation';
// import Header from "../../Components/Navbar/Header/Header";
// import SearchBar from '../../Components/Navbar/SearchBar/SearchBar';
// import PhoneModal from '../Modal/PhoneModal';
// import { URL } from "../../config";

// const HeroSection = ({ setShowPhoneModal, user, setUser ,titleSubtitle}) => {
//   console.log(titleSubtitle)
//   const [showModal, setShowModal] = useState(false);
//   // const [titleSubtitle, setTitleSubtitle] = useState(null); // store single object

//   // useEffect(() => {
//   //   const fetchTitle = async () => {
//   //     try {
//   //       const response = await axios.get(`${URL}/title-masters`);
//   //       console.log(response.data[0]);
//   //       if (response.data && response.data.length > 0) {
//   //         setTitleSubtitle(response.data[0]); // ✅ store only the first object
//   //       }
//   //     } catch (error) {
//   //       console.log(error);
//   //     }
//   //   };

//   //   fetchTitle();
//   // }, []);

//   // ⛔ Prevent rendering until data is fetched
//   if (!titleSubtitle) {
//     return <div className="header-main"></div>;
//   }

//   // Split title into prefix ("For better") and animated words
//   const words = titleSubtitle.titleName.trim().split(" ");
//   const prefix = words[0] + " " + words[1];
//   const animationWords = words.slice(2);

//   // Build animation sequence
//   const typeSequence = [];
//   animationWords.forEach(word => {
//     typeSequence.push(word);
//     typeSequence.push(1500);
//   });

//   return (
//     <div className="header-main">
//       {/* <HeroNavBar user={user}
//         setUser={setUser}
//         onLoginClick={() => setShowPhoneModal(true)} // ✅ use the prop from Home
//         /> */}
//         <Header />

//       <div className="header-title">
//         <h3>{titleSubtitle.subTitleName}</h3>
//         <h1>
//           {prefix}{' '}
//           <TypeAnimation
//             sequence={typeSequence}
//             wrapper="span"
//             speed={50}
//             cursor={true}
//             repeat={Infinity}
//             style={{ color: '#000', fontWeight: 'bold' }}
//           />
//         </h1>
//       </div>

//       <SearchBar />

//       {showModal && (
//         <PhoneModal open={showModal} handleClose={() => setShowModal(false)} />
//       )}
//     </div>
//   );
// };

// export default HeroSection;

import React, { useState } from "react";
import Slider from "react-slick";
import { TypeAnimation } from "react-type-animation";
import Header from "../../Components/Navbar/Header/Header";
import SearchBarNew from "../Navbar/SearchBar/SearchBarNew";
import PhoneModal from "../Modal/PhoneModal";
import "./Herosection.css";
import {
  Box,
  Typography,
  Grid,
  Divider,
  useMediaQuery,
  useTheme,
} from "@mui/material";
import { motion } from "framer-motion";

import HeroIMG1 from "../../assets/Header/HeroIMG3.jpg";
import HeroIMG10 from "../../assets/Header/HeroIMG1.jpg";
import HeroIMG11 from "../../assets/Header/HeroIMG9.jpeg";

const HeroSection = ({ titleSubtitle, setShowPhoneModal, user, setUser }) => {
  const [showModal, setShowModal] = useState(false);
  const [showFilters, setShowFilters] = useState(false);

  const theme = useTheme();
  const isMobile = useMediaQuery(theme.breakpoints.down("md"));

  if (!titleSubtitle) return <div className="header-main"></div>;

  const words = titleSubtitle.titleName.trim().split(" ");
  const prefix = words.slice(0, 2).join(" ");
  const animationWords = words.slice(2);
  const typeSequence = [];
  animationWords.forEach((word) => {
    typeSequence.push(word);
    typeSequence.push(1500);
  });

  const heroImages = [HeroIMG1, HeroIMG10, HeroIMG11];

  const statsData = [
    { number: "40+", label: "CITIES IN INDIA" },
    { number: "5892", label: "PROJECTS" },
    { number: "680", label: "DEVELOPERS" },
    { number: "70,751", label: "CUSTOMERS" },
    { number: "₹46000+Cr", label: "WORTH PROPERTY SOLD" },
  ];

  const sliderSettings = {
    dots: false,
    infinite: true,
    speed: 1000,
    slidesToShow: 1,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 4000,
    fade: true,
    arrows: false,
    pauseOnHover: false,
  };

  return (
    <Box sx={{ position: "relative", width: "100%", overflow: "hidden" }}>
      <Header
        user={user}
        setUser={setUser}
        onLoginClick={() => setShowPhoneModal(true)}
      />

      {/* ✅ Background Image Slider */}
      <Box
        sx={{
          position: "relative",
          height: { xs: "110vh", sm: "110vh", md: "110vh", lg: "110vh" },
        }}
      >
        <Slider {...sliderSettings}>
          {heroImages.map((img, index) => (
            <Box
              key={index}
              sx={{
                height: { xs: "110vh", sm: "110vh", md: "110vh", lg: "110vh" },
                backgroundImage: `url(${img})`,
                backgroundSize: "cover",
                backgroundPosition: "center",
                "&::before": {
                  content: '""',
                  position: "absolute",
                  inset: 0,
                  backgroundColor: "rgba(0,0,0,0.45)",
                },
              }}
            />
          ))}
        </Slider>

        {/* ✅ Text & Search */}
        <Box
          sx={{
            position: "absolute",
            top: isMobile ? "18%" : "14%",
            left: 0,
            width: "100%",
            color: "#fff",
            textAlign: "center",
            px: 2,
            zIndex: 2,
            transform: showFilters ? "translateY(20vh)" : "translateY(0)",
          }}
        >
          <Typography
            variant={isMobile ? "h6" : "h5"}
            sx={{ color: "#f0f0f0", mb: 1, fontFamily: "Poppins" }}
          >
            {titleSubtitle.subTitleName}
          </Typography>

          <Typography
            variant={isMobile ? "h4" : "h2"}
            sx={{
              fontWeight: 700,
              mb: 3,
              color: "#fff",
              textShadow: "2px 2px 10px rgba(0,0,0,0.5)",
              fontFamily: "Poppins",
            }}
          >
            {prefix}{" "}
            <TypeAnimation
              sequence={typeSequence}
              wrapper="span"
              speed={50}
              cursor={true}
              repeat={Infinity}
              style={{ color: "#FFD700", fontWeight: "bold" }}
            />
          </Typography>

          <Box
            sx={{
              mt: 4,
              width: isMobile ? "90%" : "60%",
              mx: "auto",
              position: "relative",
              zIndex: 50,
            }}
          >
            <SearchBarNew onFilterToggle={setShowFilters} />
          </Box>
        </Box>

        {/* ✅ Stats Section Over Image */}
        <Box
          sx={{
            position: "absolute",
            bottom: { xs: "0%", sm: "20%", md: "8%", lg: "15%" },
            left: "50%",
            transform: "translateX(-50%)",
            width: isMobile ? "95%" : "80%",
            // bgcolor: "rgba(0,0,0,0.55)",
            borderRadius: 2,
            py: { xs: 2, md: 3 },
            px: { xs: 1, md: 4 },
            display: "flex",
            alignItems: "center",
            justifyContent: "center",
            // backdropFilter: "blur(6px)",
            // boxShadow: "0 4px 30px rgba(0,0,0,0.2)",
            zIndex: 1,
          }}
        >
          <Grid
            container
            justifyContent="space-around"
            alignItems="center"
            spacing={2}
          >
            {statsData.map((item, index) => (
              <React.Fragment key={index}>
                <Grid item xs={6} sm={2.2} textAlign="center">
                  <motion.div
                    initial={{ opacity: 0, y: 20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.5, delay: index * 0.15 }}
                    style={{ padding: 10 }}
                  >
                    <Typography
                      variant={isMobile ? "h6" : "h5"}
                      sx={{
                        fontWeight: "bold",
                        color: "#fff",
                        fontFamily: "Poppins",
                      }}
                    >
                      {item.number}
                    </Typography>
                    <Typography
                      variant="caption"
                      sx={{
                        color: "#dcdcdc",
                        letterSpacing: 1,
                        fontSize: isMobile ? "0.7rem" : "1.3rem",
                        textTransform: "uppercase",
                        fontFamily: "Poppins",
                      }}
                    >
                      {item.label}
                    </Typography>
                  </motion.div>
                </Grid>

                {index < statsData.length - 1 && !isMobile && (
                  <Divider
                    orientation="vertical"
                    flexItem
                    sx={{
                      borderColor: "White",
                      height: 100,
                      fontFamily: "Poppins",
                    }}
                  />
                )}
              </React.Fragment>
            ))}
          </Grid>
        </Box>
      </Box>

      {showModal && (
        <PhoneModal open={showModal} handleClose={() => setShowModal(false)} />
      )}
    </Box>
  );
};

export default HeroSection;
