import React from "react";
import {
  Box,
  Container,
  Grid,
  Typography,
  Link,
  IconButton,
  Stack,
} from "@mui/material";
import {
  Instagram,
  Facebook,
  YouTube,
  LinkedIn,
  Phone,
  Email,
} from "@mui/icons-material";
import logo from "../../assets/Logo/Logo-lello2.jfif"

export default function Footerone() {
  return (
    <Box
      component="footer"
      sx={{
        bgcolor: "#1a1a1a",
        color: "white",
        py: { xs: 4, md: 6 },
        borderTop: "1px solid #333",
      }}
    >
      <Container maxWidth="lg">
        <Grid container spacing={{ xs: 3, md: 4 }}>
          {/* About Us Section */}
          <Grid item xs={12} sm={6} md={3} lg={4}>
            <Typography
              variant="h6"
              sx={{
                fontWeight: 700,
                mb: 2,
                fontSize: { xs: "1.25rem", md: "1.5rem" },
                fontFamily: "Poppins"
              }}
            >
              About Us
            </Typography>
            <Typography
              variant="body2"
              sx={{
                color: "#b0b0b0",
                lineHeight: 1.8,
                fontSize: { xs: "0.875rem", md: "0.95rem" },
                fontFamily: "Poppins"
              }}
            >
              Property is the core of every home and business.
              <br /> It is an asset, worth the investment. <br />At Sangli Properties,
               we guide you to make the right choice, <br />when it comes to
              selecting
               your place of residence or work.<br /> For a house worth to call
              home
              <br /> and a business address, where your dream thrives, Sangli
              <br />
              Properties is here for you.
            </Typography>
          </Grid>

          {/* Quick Links Section */}
          <Grid item xs={12} sm={6} md={2} lg={4}>
            <Typography
              variant="h6"
              sx={{
                fontWeight: 700,
                mb: 2,
                fontSize: { xs: "1.25rem", md: "1.5rem" },
                fontFamily: "Poppins",
              }}
            >
              Quick Links
            </Typography>
            <Stack spacing={1.5}>
              {[
                // "Lello Properties",
                // "Quick Links",
                "Home",
                "About Us",
                "Partners",
                "Contact Us",
                "Career",
              ].map((item) => (
                <Link
                  key={item}
                  href="#"
                  sx={{
                    color: "#b0b0b0",
                    textDecoration: "none",
                    fontSize: { xs: "0.875rem", md: "0.95rem" },
                    fontFamily: "Poppins",
                    borderBottom:
                      item === "Home" ||
                      item === "About Us" ||
                      item === "Partners" ||
                      item === "Contact Us"
                        ? "1px solid #444"
                        : "none",
                    pb:
                      item === "Home" ||
                      item === "About Us" ||
                      item === "Partners" ||
                      item === "Contact Us"
                        ? 0.5
                        : 0,
                    transition: "color 0.3s",
                    "&:hover": {
                      color: "#4a9eff",
                    },
                  }}
                >
                  {item}
                </Link>
              ))}
            </Stack>
          </Grid>

          {/* Our Services Section */}
          <Grid item xs={12} sm={6} md={3} lg={4}>
            <Typography
              variant="h6"
              sx={{
                fontWeight: 700,
                mb: 2,
                fontSize: { xs: "1.25rem", md: "1.5rem" },
                fontFamily: "Poppins"
              }}
            >
              Our Services
            </Typography>
            <Stack spacing={1.5}>
              {["Buy", "Sell", "Rent", "Property manager"].map((service) => (
                <Typography
                  key={service}
                  sx={{
                    color: "#b0b0b0",
                    fontSize: { xs: "0.875rem", md: "0.95rem" },
                    fontFamily: "Poppins"
                  }}
                >
                  {service}
                </Typography>
              ))}
            </Stack>
          </Grid>

          {/* Contact Us Section */}
          <Grid item xs={12} sm={6} md={4} lg={4}>
            <Typography
              variant="h6"
              sx={{
                fontWeight: 700,
                mb: 2,
                fontSize: { xs: "1.25rem", md: "1.5rem" },
                fontFamily: "Poppins"
              }}
            >
              Contact Us
            </Typography>
            <Typography
              variant="subtitle1"
              sx={{
                fontWeight: 600,
                mb: 1.5,
                fontSize: { xs: "0.95rem", md: "1.05rem" },
                fontFamily: "Poppins"
              }}
            >
              Get in touch with us
            </Typography>
            <Typography
              variant="body2"
              sx={{
                color: "#b0b0b0",
                mb: 2,
                lineHeight: 1.7,
                fontSize: { xs: "0.875rem", md: "0.95rem" },
                fontFamily: "Poppins"
              }}
            >
              <strong>
                Rajesh Bungalow, <br />
                Near Federal Bank Of Vishrambag,
                <br /> LIC Colony,
                <br />
                Near 100 Ft Road Vishrambag,
                <br /> Sangli
              </strong>
            </Typography>

            <Stack spacing={1} sx={{ mb: 2.5 }}>
              <Box sx={{ display: "flex", alignItems: "center", gap: 1 }}>
                <Email sx={{ fontSize: "1.1rem", color: "#4a9eff", }} />
                <Link
                  href="mailto:rajeshtunge@gmail.com"
                  sx={{
                    color: "#b0b0b0",
                    textDecoration: "none",
                    fontSize: { xs: "0.875rem", md: "0.95rem" },
                    "&:hover": { color: "#4a9eff" },
                    fontFamily: "Poppins"
                  }}
                >
                  rajeshtunge@gmail.com
                </Link>
              </Box>
              <Box sx={{ display: "flex", alignItems: "center", gap: 1 }}>
                <Phone sx={{ fontSize: "1.1rem", color: "#4a9eff" }} />
                <Typography
                  sx={{
                    color: "#b0b0b0",
                    fontSize: { xs: "0.875rem", md: "0.95rem" },
                    fontFamily: "Poppins"
                  }}
                >
                  +91-7385077033 / 9146636555
                </Typography>
              </Box>
            </Stack>

            {/* Social Icons */}
            <Stack direction="row" spacing={1} sx={{ mb: 2 }}>
              {[
                { icon: <Instagram />, label: "Instagram" },
                { icon: <Facebook />, label: "Facebook" },
                { icon: <YouTube />, label: "YouTube" },
                { icon: <LinkedIn />, label: "LinkedIn" },
              ].map((social) => (
                <IconButton
                  key={social.label}
                  aria-label={social.label}
                  sx={{
                    color: "white",
                    bgcolor: "#2a2a2a",
                    "&:hover": {
                      bgcolor: "#4a9eff",
                      transform: "translateY(-3px)",
                    },
                    transition: "all 0.3s",
                  }}
                  size="small"
                >
                  {social.icon}
                </IconButton>
              ))}
            </Stack>

            {/* Lello Logo */}
            <Box
              sx={{
                mt: 2,
                display: "flex",
                alignItems: "center",
                gap: 0.5,
              }}
            >
              <Box
                component="img"
                src={logo}
                alt="Lello Logo"
                sx={{
                  height: { xs: 40, md: 100 },
                  width: "auto",
                }}
              />
             
            </Box>
          </Grid>
        </Grid>

        {/* Bottom Copyright */}
        <Box
          sx={{
            mt: 4,
            pt: 3,
            borderTop: "1px solid #333",
            textAlign: "center",
          }}
        >
          <Typography
            variant="body2"
            sx={{
              color: "#888",
              fontSize: { xs: "0.8rem", md: "0.875rem" },
              fontFamily: "Poppins"
            }}
          >
            © {new Date().getFullYear()} Lello Properties. All rights reserved.
          </Typography>
        </Box>
      </Container>
    </Box>
  );
}

// export default Footerone
