import React from "react";
import { Row, Col, Typography, Space, Button } from "antd";
import {
  FacebookFilled,
  InstagramFilled,
  YoutubeFilled,
  LinkedinFilled,
} from "@ant-design/icons";
import Logo from "../../assets/Logo/Lello-Logo.png"; // replace with your logo path

const { Title, Text, Link } = Typography;

const Footer = () => {
  const year = new Date().getFullYear();

  return (
    <div
      style={{
        backgroundColor: "#255670",
        color: "#fff",
        padding: "60px 40px 20px 40px",
      }}
    >
      <Row gutter={[32, 32]} justify="center">
        {/* 🔹 Logo + Social */}
        <Col xs={24} sm={24} md={12} lg={8}>
          <div style={{ textAlign: "center" }}>
            <img
              src={Logo}
              alt="Logo"
              style={{ width: "130px", height: "auto" }}
            />
            <Text
              style={{
                display: "block",
                marginTop: "10px",
                color: "#ccc",
                fontSize: "14px",
              }}
            >
              Lello Properties
            </Text>

            <Space
              size="middle"
              style={{ marginTop: "15px", justifyContent: "center" }}
            >
              {[FacebookFilled, YoutubeFilled, InstagramFilled, LinkedinFilled].map(
                (Icon, i) => (
                  <Button
                    key={i}
                    shape="circle"
                    icon={<Icon style={{ color: "#FFD700", fontSize: "18px" }} />}
                    href="#"
                    style={{
                      background: "transparent",
                      // border: "1px solid #333",
                    }}
                  />
                )
              )}
            </Space>
          </div>
        </Col>

        {/* 🔹 Quick Links */}
        <Col xs={24} sm={12} md={6} lg={5}>
          <Title
            level={5}
            style={{ color: "#fff", marginBottom: "15px", fontSize: "1.1rem" }}
          >
            Quick Links
          </Title>
          <Space direction="vertical" size={8}>
            {["Home", "About Us", "Partners", "Contact Us","Career"].map((item) => (
              <Link
                key={item}
                href="#"
                style={{
                  color: "#ccc",
                  fontSize: "0.95rem",
                  transition: "color 0.3s",
                }}
                onMouseEnter={(e) => (e.target.style.color = "#FFD700")}
                onMouseLeave={(e) => (e.target.style.color = "#ccc")}
              >
                {item}
              </Link>
            ))}
          </Space>
        </Col>

        {/* 🔹 Our Services */}
        <Col xs={24} sm={12} md={6} lg={5}>
          <Title
            level={5}
            style={{ color: "#fff", marginBottom: "15px", fontSize: "1.1rem" }}
          >
            Our Services
          </Title>
          <Space direction="vertical" size={8}>
            {["Buy", "Sell", "Rent","Property manager"].map((service) => (
              <Text key={service} style={{ color: "#ccc", fontSize: "0.95rem" }}>
                {service}
              </Text>
            ))}
          </Space>
        </Col>

        {/* 🔹 Contact Info */}
        <Col xs={24} sm={24} md={12} lg={6}>
          <Title
            level={5}
            style={{ color: "#fff", marginBottom: "15px", fontSize: "1.1rem" }}
          >
            Contact us & location
          </Title>
          <Space
            direction="vertical"
            size={10}
            style={{ color: "#ccc", fontSize: "0.9rem" }}
          >
            <Text style={{ color: "#ccc", fontSize: "0.9rem" }}>
              2/2, Achalare House, <br /> 2/3, S.No.1/2/1, Baner Rd, <br /> Baner
              Gaon, Pune, Maharashtra 411045
            </Text>
            <Text style={{ color: "#ccc", fontSize: "0.9rem" }}>
              East Pune: No 1, Nyati Plaza, <br /> Next to Reliance Mall, <br />
              Mundhwa-Kharadi Bypass, Kharadi, <br /> Pune 411014
            </Text>
            <Text style={{ color: "#ccc", fontSize: "0.9rem" }}>
              Echoing Greens 302, near Irani Cafe, <br /> Shankar Kalat Nagar,
              Wakad, Pune, <br /> Pimpri-Chinchwad, Maharashtra 411057
            </Text>
            <Text style={{ color: "#ccc", fontSize: "0.9rem" }}>
              +91 87558 87558
            </Text>
            <Text style={{ color: "#ccc", fontSize: "0.9rem" }}>
              info@therealestatemall.com
            </Text>
          </Space>
        </Col>
      </Row>

      {/* 🔹 Bottom Copyright */}
      <div
        style={{
          borderTop: "1px solid #333",
          textAlign: "center",
          marginTop: "50px",
          paddingTop: "20px",
          color: "#aaa",
          fontSize: "0.85rem",
        }}
      >
        © {year} Lello Properties . All Rights Reserved.
      </div>
    </div>
  );
};

export default Footer;
