import React, { useEffect } from 'react';
import {
  Modal,
  Box,
  Typography,
  IconButton
} from '@mui/material';
import CloseIcon from '@mui/icons-material/Close';
import CheckCircleOutlineIcon from '@mui/icons-material/CheckCircleOutline';

const style = {
  position: 'absolute',
  top: '50%',
  left: '50%',
  transform: 'translate(-50%, -50%)',
  width: 350,
  height:200,
  bgcolor: 'background.paper',
  borderRadius: 2,
  boxShadow: 24,
  p: 4,
  outline: 'none',
  textAlign: 'center'
};

export default function SuccessPostAlt({ open, onClose }) {
  useEffect(() => {
    if (open) {
      const timer = setTimeout(() => {
        onClose();
      }, 3000); // auto-close after 3 seconds
      return () => clearTimeout(timer);
    }
  }, [open, onClose]);

  return (
    <Modal open={open} onClose={onClose}>
      <Box sx={style}>
        {/* <Box display="flex" justifyContent="flex-end">
          <IconButton onClick={onClose}>
            <CloseIcon />
          </IconButton>
        </Box> */}

        <CheckCircleOutlineIcon sx={{ fontSize: 60, color: 'green',   }} />

        <Typography variant="h5" fontWeight="bold"  >
          Success!
        </Typography>

        <Typography variant="body1" color="text.secondary" mb={2}>
          You’ve successfully Post Property.
        </Typography>
      </Box>
    </Modal>
  );
}
