import React from "react";
import { Row, Col, Typography } from "antd";
import { motion } from "framer-motion";
import "./vision.css";
import VisionIMG from "../../../Assets/AboutUs/vision.png";

const { Title } = Typography;

const Vision = () => {
  return (
    <section className="vision-wrapper">
      <Row gutter={[32, 32]} align="middle" justify="center">

      
        <Col xs={24} sm={24} md={12} className="vision-text">
          <motion.div
            initial={{ opacity: 0, x: -60 }}
            whileInView={{ opacity: 1, x: 0 }}
            viewport={{ once: false, amount: 0.25 }}
            transition={{ duration: 0.7 }}
          >
            <Title level={1} className="vision-title">
              Our Vision
            </Title>

            <div className="vision-points">
              <div className="vision-point">
                <span className="vision-highlight">Transparency & Trust</span>
                <p>
                  To create a real estate ecosystem where transparency, honesty, and
                  trust form the foundation of every client relationship.
                </p>
              </div>

              <div className="vision-point">
                <span className="vision-highlight">Innovation Driven Growth</span>
                <p>
                  To leverage technology and modern tools that simplify property
                  transactions and enhance decision-making experiences.
                </p>
              </div>

              <div className="vision-point">
                <span className="vision-highlight">Client-Centric Approach</span>
                <p>
                  To understand evolving client needs and deliver personalized,
                  value-driven real estate solutions.
                </p>
              </div>

              <div className="vision-point">
                <span className="vision-highlight">Sustainable Communities</span>
                <p>
                  To contribute toward responsible development that supports
                  long-term community growth and environmental balance.
                </p>
              </div>

              <div className="vision-point">
                <span className="vision-highlight">Industry Excellence</span>
                <p>
                  To consistently raise service standards and become a benchmark
                  for quality and professionalism in real estate.
                </p>
              </div>
            </div>
          </motion.div>
        </Col>

       
        <Col xs={24} sm={24} md={12} className="vision-images">
          <motion.img
            src={VisionIMG} 
            className="v-img-single"
            initial={{ opacity: 0, x: 60 }}
            whileInView={{ opacity: 1, x: 0 }}
            viewport={{ once: false, amount: 0.25 }}
            transition={{ duration: 0.8 }}
          />
        </Col>

      </Row>
    </section>
  );
};

export default Vision;
