import React, { useRef, useEffect, useState } from "react";
import { Row, Col, Typography } from "antd";
import { motion } from "framer-motion";
import "./storysection.css";
import StoryIMG from "../../../Assets/AboutUs/story.webp";

const { Title, Paragraph } = Typography;

const StorySection = () => {
  const textRef = useRef(null);
  const [textHeight, setTextHeight] = useState("auto");

  useEffect(() => {
    if (textRef.current) {
      setTextHeight(textRef.current.clientHeight + "px");
    }
    const handleResize = () => {
      if (textRef.current) {
        setTextHeight(textRef.current.clientHeight + "px");
      }
    };
    window.addEventListener("resize", handleResize);
    return () => window.removeEventListener("resize", handleResize);
  }, []);

  return (
    <section className="story-wrapper">
      <Row gutter={[48, 48]} align="top">

        <Col xs={24} md={12} className="story-text" ref={textRef}>
          <motion.div
            initial={{ opacity: 0, x: -50 }}
            whileInView={{ opacity: 1, x: 0 }}
            viewport={{ once: false, amount: 0.3 }}
            transition={{ duration: 0.8, ease: "easeOut" }}
          >
            <Title level={1} className="story-title">
              Our Story of Success
            </Title>

            <Paragraph className="story-paragraph">
              Our journey in real estate began with a vision to create spaces
              that combine comfort, functionality, and aesthetic excellence.
              Every project we undertake reflects this commitment.
            </Paragraph>

            <Paragraph className="story-paragraph">
              Over the years, we have worked closely with buyers, sellers, and
              investors, ensuring that each property transaction is smooth,
              transparent, and trustworthy.
            </Paragraph>

            <Paragraph className="story-paragraph">
              We believe in a people-first approach, understanding the unique
              needs of each client, and providing personalized solutions that
              align with their goals and lifestyle.
            </Paragraph>

            <Paragraph className="story-paragraph">
              Our team’s expertise in planning, design, and execution ensures
              that every project is delivered with precision, quality, and
              attention to detail.
            </Paragraph>

            <Paragraph className="story-paragraph">
              Today, our success is measured not just in the properties we
              deliver, but in the lasting relationships we build, founded on
              integrity, innovation, and excellence.
            </Paragraph>
          </motion.div>
        </Col>

   
        <Col xs={24} md={12} className="story-image-col">
          <motion.div
            className="story-image-wrapper"
            style={{ height: textHeight }}
            initial={{ opacity: 0, x: 50 }}
            whileInView={{ opacity: 1, x: 0 }}
            viewport={{ once: false, amount: 0.3 }}
            transition={{ duration: 0.8, ease: "easeOut" }}
          >
            <img
              src={StoryIMG}
              alt="Real estate success story"
              className="story-image"
            />
          </motion.div>
        </Col>
      </Row>
    </section>
  );
};




export default StorySection