import React from "react";
import { Typography } from "antd";
import { motion } from "framer-motion";
import "./AboutUsHeroImg.css";
import HeroIMG from "../../../Assets/AboutUs/aboutus.avif";

const { Title } = Typography;

const AboutUsHeroImg = () => {
  return (
    <div className="about-wrapper">
      <motion.div
        className="about-hero"
        initial={{ scale: 1.2 }}
        animate={{ scale: 1 }}
        transition={{ duration: 1.5, ease: "easeOut" }}
      >
        <img
          src={HeroIMG}
          alt="About Us"
          className="about-hero-img"
        />

        <div className="overlay" />

        <motion.div
          className="hero-content"
          initial={{ opacity: 0, y: 30 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ delay: 0.5, duration: 0.8 }}
        >
          <div className="hero-title">About Us</div>
          <Title level={3} className="hero-subtitle">
            LELLO PROPERTIES
          </Title>
        </motion.div>
      </motion.div>
    </div>
  );
};

export default AboutUsHeroImg;