/* eslint-disable @typescript-eslint/no-explicit-any */



// import axios from "axios";

// export async function sendOtpWhatsapp(phoneNumber: string, otp: string): Promise<{success: boolean; isWhatsapp?: boolean}> {
//   try {
//     const apiKey = "645aa044d4444923913d976d0038374d";
//     const message = `Your OTP is ${otp}`;

//     const response = await axios.get("http://148.251.129.118/wapp/api/send", {
//       params: {apikey: apiKey, mobile: phoneNumber, msg: message}
//     });

//     console.log("WhatsApp API Response:", JSON.stringify(response.data));
//     const responseData = response.data?.toString().toLowerCase();
//     console.log(responseData)
//     if (response.data?.toString().includes("Invalid") || response.data?.toString().includes("not whatsapp")) {
//       return {success: false, isWhatsapp: false};
//     }

//     return {success: true, isWhatsapp: true};
//   } catch (error: any) {
//     console.error("WhatsApp API Error Response Data:", error.response?.data);
//     console.error("WhatsApp API Error Message:", error.message);

//     if (error.response?.data?.toString().includes("Invalid")) {
//       return {success: false, isWhatsapp: false};
//     }

//     return {success: false};
//   }
// }





// import axios from 'axios';

// export interface WhatsappOtpResponse {
//   success: boolean;
//   isWhatsapp?: boolean;
//   error?: string;
// }

// export async function sendOtpWhatsapp(
//   phoneNumber: string,
//   otp: string
// ): Promise<WhatsappOtpResponse> {
//   try {
//     const apiKey = 'bXZzR25YWnpOaEM2dGdXWG9DV3pmdz09';
//     const message = `Your OTP is ${otp}`;

//     const response = await axios.get('http://148.251.129.118/wapp/api/send', {
//       params: {apikey: apiKey, mobile: phoneNumber, msg: message},
//     });

//     console.log('WhatsApp API Response:', JSON.stringify(response.data));
//     const responseData = response.data;

//     if (
//       responseData?.status === 'ERROR' &&
//       responseData?.errormsg?.toLowerCase().includes('no valid mobile found')
//     ) {
//       return {success: false, isWhatsapp: false, error: responseData.errormsg};
//     }

//     return {success: true, isWhatsapp: true};
//   } catch (error: any) {
//     console.error('WhatsApp API Error Response Data:', error.response?.data);
//     console.error('WhatsApp API Error Message:', error.message);

//     const errorData = error.response?.data?.errormsg?.toString().toLowerCase() || '';

//     if (errorData.includes('no valid mobile found')) {
//       return {success: false, isWhatsapp: false, error: error.response?.data?.errormsg};
//     }

//     return {success: false, error: error.message};
//   }
// };


import axios from 'axios';

export interface WhatsappOtpResponse {
  success: boolean;
  isWhatsapp?: boolean;
  error?: string;
}

export async function sendOtpWhatsapp(
  phoneNumber: string,
  otp: string
): Promise<WhatsappOtpResponse> {
  try {
    const token = 'bXZzR25YWnpOaEM2dGdXWG9DV3pmdz09';
    const username = 'Comtranse';

    // ⚠️ Phone must be with country code and NO +
    const formattedNumber = phoneNumber.startsWith('91')
      ? phoneNumber
      : `91${phoneNumber}`;

    const message = `Your OTP is ${otp}`;

    const response = await axios.get(
      'https://int.chatway.in/api/send-msg',
      {
        params: {
          username,
          number: formattedNumber,
          message,
          token,
        },
      }
    );

    // console.log('Chatway WhatsApp Response:', response.data);

    // Adjust success condition based on actual API response
    if (response.data?.status === true || response.status === 200) {
      return { success: true, isWhatsapp: true };
    }

    return {
      success: false,
      isWhatsapp: false,
      error: response.data?.message || 'Unknown API error',
    };
  } catch (error: any) {
    console.error('Chatway API Error:', error.response?.data || error.message);

    return {
      success: false,
      isWhatsapp: false,
      error: error.response?.data?.message || error.message,
    };
  }
}
