// import {inject} from '@loopback/core';
// import {DefaultCrudRepository} from '@loopback/repository';
// import {DblelloDataSource} from '../datasources';
// import {Usertype, UsertypeRelations} from '../models';

// export class UsertypeRepository extends DefaultCrudRepository<
//   Usertype,
//   typeof Usertype.prototype.userId,
//   UsertypeRelations
// > {
//   constructor(
//     @inject('datasources.dblello') dataSource: DblelloDataSource,
//   ) {
//     super(Usertype, dataSource);
//   }
// }



import {Getter, inject} from '@loopback/core';
import {DefaultCrudRepository, HasManyRepositoryFactory, repository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {BuyerMaster, SellerMaster, Usertype, UsertypeRelations} from '../models';
import {BuyerMasterRepository} from './buyer-master.repository';
import {SellerMasterRepository} from './seller-master.repository';

export class UsertypeRepository extends DefaultCrudRepository<
  Usertype,
  typeof Usertype.prototype.userId,
  UsertypeRelations
> {
  public readonly sellers: HasManyRepositoryFactory<SellerMaster, typeof Usertype.prototype.userId>;
  public readonly buyers: HasManyRepositoryFactory<BuyerMaster, typeof Usertype.prototype.userId>;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
    @repository.getter('SellerMasterRepository') protected sellerMasterRepositoryGetter: Getter<SellerMasterRepository>,
    @repository.getter('BuyerMasterRepository') protected buyerMasterRepositoryGetter: Getter<BuyerMasterRepository>,
  ) {
    super(Usertype, dataSource);

    this.sellers = this.createHasManyRepositoryFactoryFor('sellers', sellerMasterRepositoryGetter);
    this.registerInclusionResolver('sellers', this.sellers.inclusionResolver);

    this.buyers = this.createHasManyRepositoryFactoryFor('buyers', buyerMasterRepositoryGetter);
    this.registerInclusionResolver('buyers', this.buyers.inclusionResolver);
  }
}
