// import {inject} from '@loopback/core';
// import {DefaultCrudRepository} from '@loopback/repository';
// import {DblelloDataSource} from '../datasources';
// import {SellerMaster, SellerMasterRelations} from '../models';

// export class SellerMasterRepository extends DefaultCrudRepository<
//   SellerMaster,
//   typeof SellerMaster.prototype.sellerId,
//   SellerMasterRelations
// > {
//   constructor(
//     @inject('datasources.dblello') dataSource: DblelloDataSource,
//   ) {
//     super(SellerMaster, dataSource);
//   }
// }


import {Getter, inject} from '@loopback/core';
import {BelongsToAccessor, DefaultCrudRepository, repository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {CityMaster, GenderMaster,
  // PackageMaster,
   SellerMaster, SellerMasterRelations, Usertype} from '../models';
import {CityMasterRepository} from './city-master.repository';
import {GenderMasterRepository} from './gender-master.repository';
// import {PackageMasterRepository} from './package-master.repository';
import {UsertypeRepository} from './usertype.repository';

export class SellerMasterRepository extends DefaultCrudRepository<
  SellerMaster,
  typeof SellerMaster.prototype.sellerId,
  SellerMasterRelations
> {

  public readonly city: BelongsToAccessor<CityMaster, typeof SellerMaster.prototype.sellerId>;
  // public readonly package: BelongsToAccessor<PackageMaster, typeof SellerMaster.prototype.sellerId>;
  public readonly user: BelongsToAccessor<Usertype, typeof SellerMaster.prototype.sellerId>;
  public readonly gender: BelongsToAccessor<GenderMaster, typeof SellerMaster.prototype.sellerId>;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
    @repository.getter('CityMasterRepository') protected cityRepoGetter: Getter<CityMasterRepository>,
    // @repository.getter('PackageMasterRepository') protected packageRepoGetter: Getter<PackageMasterRepository>,
    @repository.getter('UsertypeRepository') protected userRepoGetter: Getter<UsertypeRepository>,
    @repository.getter('GenderMasterRepository') protected genderRepoGetter: Getter<GenderMasterRepository>,
  ) {
    super(SellerMaster, dataSource);

    this.city = this.createBelongsToAccessorFor('city', cityRepoGetter);
    // this.package = this.createBelongsToAccessorFor('package', packageRepoGetter);
    this.user = this.createBelongsToAccessorFor('user', userRepoGetter);
    this.gender = this.createBelongsToAccessorFor('gender', genderRepoGetter);

    this.registerInclusionResolver('city', this.city.inclusionResolver);
    // this.registerInclusionResolver('package', this.package.inclusionResolver);
    this.registerInclusionResolver('user', this.user.inclusionResolver);
    this.registerInclusionResolver('gender', this.gender.inclusionResolver);
  }
}
