import {inject, Getter} from '@loopback/core';
import {DefaultCrudRepository, repository, BelongsToAccessor} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {RecommendedLaunch, RecommendedLaunchRelations, PostPropertyMaster} from '../models';
import {PostPropertyMasterRepository} from './post-property-master.repository';

export class RecommendedLaunchRepository extends DefaultCrudRepository<
  RecommendedLaunch,
  typeof RecommendedLaunch.prototype.reclaunchId,
  RecommendedLaunchRelations
> {
  public readonly postproperty: BelongsToAccessor<PostPropertyMaster, typeof RecommendedLaunch.prototype.reclaunchId>;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
    @repository.getter('PostPropertyMasterRepository')
    protected postPropertyMasterRepositoryGetter: Getter<PostPropertyMasterRepository>,
  ) {
    super(RecommendedLaunch, dataSource);

    this.postproperty = this.createBelongsToAccessorFor(
      'postproperty',
      postPropertyMasterRepositoryGetter,
    );

    this.registerInclusionResolver('postproperty', this.postproperty.inclusionResolver);
  }
}
