import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {PropertylistingMaster, PropertylistingMasterRelations} from '../models';

export class PropertylistingMasterRepository extends DefaultCrudRepository<
  PropertylistingMaster,
  typeof PropertylistingMaster.prototype.propertylistId,
  PropertylistingMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(PropertylistingMaster, dataSource);
  }
}
