import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {PossessionMaster, PossessionMasterRelations} from '../models';

export class PossessionMasterRepository extends DefaultCrudRepository<
  PossessionMaster,
  typeof PossessionMaster.prototype.possessionId,
  PossessionMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(PossessionMaster, dataSource);
  }
}
