import {Getter, inject} from '@loopback/core';
import {BelongsToAccessor, DefaultCrudRepository, repository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {PackageMaster, PackageMasterRelations, Usertype} from '../models';
import {UsertypeRepository} from './usertype.repository';

export class PackageMasterRepository extends DefaultCrudRepository<
  PackageMaster,
  typeof PackageMaster.prototype.packageId,
  PackageMasterRelations
> {
  public readonly usertype: BelongsToAccessor<Usertype, typeof PackageMaster.prototype.packageId>;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
    @repository.getter('UsertypeRepository') protected usertypeRepositoryGetter: Getter<UsertypeRepository>,
  ) {
    super(PackageMaster, dataSource);

    this.usertype = this.createBelongsToAccessorFor('usertype', usertypeRepositoryGetter);
    this.registerInclusionResolver('usertype', this.usertype.inclusionResolver);
  }
}
