import {Getter, inject} from '@loopback/core';
import {BelongsToAccessor, DefaultCrudRepository, repository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {BestpropertyLaunch, NewLaunchMaster, NewLaunchMasterRelations, PostPropertyMaster} from '../models';
import {PostPropertyMasterRepository} from './post-property-master.repository';

export class NewLaunchMasterRepository extends DefaultCrudRepository<
  NewLaunchMaster,
  typeof NewLaunchMaster.prototype.newLaunchId,
  NewLaunchMasterRelations
> {
  public readonly postproperty: BelongsToAccessor<
      PostPropertyMaster,
      typeof BestpropertyLaunch.prototype.bestlaunchId
    >;
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
     @repository.getter('PostPropertyMasterRepository')
        protected postPropertyMasterRepositoryGetter: Getter<PostPropertyMasterRepository>,
  ) {
    super(NewLaunchMaster, dataSource);

    // create accessor and register inclusion resolver
    this.postproperty = this.createBelongsToAccessorFor(
      'postproperty',
      postPropertyMasterRepositoryGetter,
    );

    this.registerInclusionResolver('postproperty', this.postproperty.inclusionResolver);
  }
}
