import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {MaintenanceMonthMaster, MaintenanceMonthMasterRelations} from '../models';

export class MaintenanceMonthMasterRepository extends DefaultCrudRepository<
  MaintenanceMonthMaster,
  typeof MaintenanceMonthMaster.prototype.maintenanacemonthId,
  MaintenanceMonthMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(MaintenanceMonthMaster, dataSource);
  }
}
