import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {LogoMaster, LogoMasterRelations} from '../models';

export class LogoMasterRepository extends DefaultCrudRepository<
  LogoMaster,
  typeof LogoMaster.prototype.logoId,
  LogoMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(LogoMaster, dataSource);
  }
}
