import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {LogBuyersearch, LogBuyersearchRelations} from '../models';

export class LogBuyersearchRepository extends DefaultCrudRepository<
  LogBuyersearch,
  typeof LogBuyersearch.prototype.logBuyersearchId,
  LogBuyersearchRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(LogBuyersearch, dataSource);
  }
}
