import {inject} from '@loopback/core';
import {DefaultCrudRepository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {ExclusivePropertyMaster, ExclusivePropertyMasterRelations} from '../models';

export class ExclusivePropertyMasterRepository extends DefaultCrudRepository<
  ExclusivePropertyMaster,
  typeof ExclusivePropertyMaster.prototype.exclusivePropertyId,
  ExclusivePropertyMasterRelations
> {
  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
  ) {
    super(ExclusivePropertyMaster, dataSource);
  }
}
