// import {inject} from '@loopback/core';
// import {DefaultCrudRepository} from '@loopback/repository';
// import {DblelloDataSource} from '../datasources';
// import {CityMaster, CityMasterRelations} from '../models';

// export class CityMasterRepository extends DefaultCrudRepository<
//   CityMaster,
//   typeof CityMaster.prototype.cityId,
//   CityMasterRelations
// > {
//   constructor(
//     @inject('datasources.dblello') dataSource: DblelloDataSource,
//   ) {
//     super(CityMaster, dataSource);
//   }
// }



import {Getter, inject} from '@loopback/core';
import {DefaultCrudRepository, HasManyRepositoryFactory, repository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {BuyerMaster, CityMaster, CityMasterRelations, SellerMaster} from '../models';
import {BuyerMasterRepository} from './buyer-master.repository';
import {SellerMasterRepository} from './seller-master.repository';

export class CityMasterRepository extends DefaultCrudRepository<
  CityMaster,
  typeof CityMaster.prototype.cityId,
  CityMasterRelations
> {
  public readonly buyers: HasManyRepositoryFactory<BuyerMaster, typeof CityMaster.prototype.cityId>;
  public readonly sellers: HasManyRepositoryFactory<SellerMaster, typeof CityMaster.prototype.cityId>; // 👈

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
    @repository.getter('BuyerMasterRepository') protected buyerMasterRepositoryGetter: Getter<BuyerMasterRepository>,
    @repository.getter('SellerMasterRepository') protected sellerMasterRepositoryGetter: Getter<SellerMasterRepository>, // 👈
  ) {
    super(CityMaster, dataSource);

    this.buyers = this.createHasManyRepositoryFactoryFor('buyers', buyerMasterRepositoryGetter);
    this.registerInclusionResolver('buyers', this.buyers.inclusionResolver);

    this.sellers = this.createHasManyRepositoryFactoryFor('sellers', sellerMasterRepositoryGetter); // 👈
    this.registerInclusionResolver('sellers', this.sellers.inclusionResolver);
  }
}
