// import {inject} from '@loopback/core';
// import {DefaultCrudRepository} from '@loopback/repository';
// import {DblelloDataSource} from '../datasources';
// import {BuyerMaster, BuyerMasterRelations} from '../models';

// export class BuyerMasterRepository extends DefaultCrudRepository<
//   BuyerMaster,
//   typeof BuyerMaster.prototype.buyerId,
//   BuyerMasterRelations
// > {
//   constructor(
//     @inject('datasources.dblello') dataSource: DblelloDataSource,
//   ) {
//     super(BuyerMaster, dataSource);
//   }
// }



// new code relation
import {Getter, inject} from '@loopback/core';
import {BelongsToAccessor, DefaultCrudRepository, repository} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {BuyerMaster, BuyerMasterRelations, CityMaster, GenderMaster, Usertype} from '../models';
import {CityMasterRepository} from './city-master.repository';
import {GenderMasterRepository} from './gender-master.repository';
import {UsertypeRepository} from './usertype.repository';

export class BuyerMasterRepository extends DefaultCrudRepository<
  BuyerMaster,
  typeof BuyerMaster.prototype.buyerId,
  BuyerMasterRelations
> {

  // BelongsTo accessors
  public readonly city: BelongsToAccessor<CityMaster, typeof BuyerMaster.prototype.buyerId>;
  public readonly gender: BelongsToAccessor<GenderMaster, typeof BuyerMaster.prototype.buyerId>;
  public readonly usertype: BelongsToAccessor<Usertype, typeof BuyerMaster.prototype.buyerId>;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
    @repository.getter('CityMasterRepository') protected cityRepoGetter: Getter<CityMasterRepository>,
    @repository.getter('GenderMasterRepository') protected genderRepoGetter: Getter<GenderMasterRepository>,
    @repository.getter('UsertypeRepository') protected usertypeRepoGetter: Getter<UsertypeRepository>,
  ) {
    super(BuyerMaster, dataSource);

    // Create BelongsTo accessors
    this.city = this.createBelongsToAccessorFor('city', cityRepoGetter);
    this.gender = this.createBelongsToAccessorFor('gender', genderRepoGetter);
    this.usertype = this.createBelongsToAccessorFor('usertype', usertypeRepoGetter);

    // Register inclusion resolvers
    this.registerInclusionResolver('city', this.city.inclusionResolver);
    this.registerInclusionResolver('gender', this.gender.inclusionResolver);
    this.registerInclusionResolver('usertype', this.usertype.inclusionResolver);
  }
}

