import {inject, Getter} from '@loopback/core';
import {DefaultCrudRepository, repository, BelongsToAccessor} from '@loopback/repository';
import {DblelloDataSource} from '../datasources';
import {BestpropertyLaunch, BestpropertyLaunchRelations, PostPropertyMaster} from '../models';
import {PostPropertyMasterRepository} from './post-property-master.repository';

export class BestpropertyLaunchRepository extends DefaultCrudRepository<
  BestpropertyLaunch,
  typeof BestpropertyLaunch.prototype.bestlaunchId,
  BestpropertyLaunchRelations
> {
  public readonly postproperty: BelongsToAccessor<
    PostPropertyMaster,
    typeof BestpropertyLaunch.prototype.bestlaunchId
  >;

  constructor(
    @inject('datasources.dblello') dataSource: DblelloDataSource,
    @repository.getter('PostPropertyMasterRepository')
    protected postPropertyMasterRepositoryGetter: Getter<PostPropertyMasterRepository>,
  ) {
    super(BestpropertyLaunch, dataSource);

    // create accessor and register inclusion resolver
    this.postproperty = this.createBelongsToAccessorFor(
      'postproperty',
      postPropertyMasterRepositoryGetter,
    );

    this.registerInclusionResolver('postproperty', this.postproperty.inclusionResolver);
  }
}
